import math

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 500., 5001)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
X1 = 0.91
X2 = 0.4
X0 = [X1, X2]

def fun(X, t):
    X1, X2 = X
    dX1 = X2
    dX2 = X1 - X1**3 - 0.25*X2 + 0.265*math.sin(t)

    return [dX1, dX2]


sol = odeint(fun, X0, t)        # call solver

X1 = sol[:, 0]
X2 = sol[:, 1]

#Graph plotting
plt.figure()
plt.plot(t, X1,label = "X1")
plt.plot(t, X2, label = "X2")
plt.xlabel('t')
plt.grid()
plt.legend(loc="best")
plt.show()