
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 10., 101)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
X1 = 2
X2 = 4
X3 = 6
X4 = 0.5
X5 = 0.1
X6 = 0.1
X0 = [X1, X2, X3, X4, X5, X6]

x0 = 1
a1 = 5
b1 = 0.2
b2 = 2
b3 = 2
b4 = 2
c1 = 3
c2 = 0.5
c3 = 0.5
n=3
g = 2 * np.random.random(n**2) -2
h = 4 * np.random.random(n**2)

def fun(X, t, x0, a1, b1, b2, b3, b4, c1, c2, c3, g, h):
    X1, X2, X3, X4 ,X5, X6 = X

    dXdt = [
            a1 * x0 * X4 ** g - b1 * X1 - c1 * X1 ** 2 * X4 ** h,   # dX1dt differential equation for X1
            b1 * X1 - b2 * X2 ** 0.4,                               # dX2dt differential equation for X2
            b2 * X2 ** 0.4 - b3 * X3 ** 0.7,                        # dx3dt differential equation for X3
            b3 * X3 ** 0.7 - b4 * X4 ** 0.8,                        # dX4dt differential equation for X4
            c1 * X1 ** 2 * X4 ** h - c2 * X5,                       # dX5dt differential equation for X5 ?
            c2 * X5 - c3 * X6                                       # dX6dt differential equation for X6
            ]

    return dXdt

fig, axs = plt.subplots(n,n)
for i in range(n**2):
    arg = (x0, a1, b1, b2, b3, b4, c1, c2, c3, g[i], h[i])
    sol = odeint(fun, y0 = X0, t = t, args = arg)        # call solver

    X1 = sol[:, 0]
    X2 = sol[:, 1]
    X3 = sol[:, 2]
    X4 = sol[:, 3]
    X5 = sol[:, 4]
    X6 = sol[:, 5]

    #Graph plotting
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].plot(t, X1)
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].set_title('g = ' + str(round(g[i],2)) + ' | h = ' + str(round(h[i],2)))
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].plot(t, X2)
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].plot(t, X3)
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].plot(t, X4)
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].plot(t, X5)
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].plot(t, X6)
    axs[int(i/3),int(round(3*(i/3 - int(i/3)),0))].grid()


for ax in axs.flat:
    ax.set(xlabel='x-label', ylabel='y-label')

# Hide x labels and tick labels for top plots and y ticks for right plots.
for ax in axs.flat:
    ax.label_outer()
plt.show()

