
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
from scipy.integrate import solve_ivp
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 400., 4001)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
B = 1278.037
P = 64.7532
A = 15.04461
H = 1713.089
D = 100
M = 12.75542
X0 = [B, P, A, H, D, M]

CF_values = [0,1]
CF_title = ['Wild type | CF = 0','Cystic Fibrosis | CF = 1']

def fun(t,X):
    B, P, A, H, D, M = X

    # antibiotics
    AB = 0
    AB = 5 if (t > 22) else AB
    AB = 0 if (t > 32) else AB
    AB = 5 if (t > 162) else AB
    AB = 0 if (t > 172) else AB
    AB = 5 if (t > 302) else AB
    AB = 0 if (t > 312) else AB

    dXdt = [
        (B ** 0.8 * M ** 1.2 - 0.8 * B ** 1.2 * P ** 0.1 * (AB + 1)) * M ** (-2.4),       # dBdt differential equation for B
        20 * B ** 0.2 * D ** 0.4 * A ** -0.1 - 50 * P ** 0.5,                           # dPdt differential equation for P
        15 * B ** 0.1 * P ** 0.1 - 12 * A ** 0.5,                                      # dAdt differential equation for A
        500 - 40 * H ** 0.3 * P ** 0.2 * A ** (-0.2),                                  # dHdt differential equation for H
        40 * H ** 0.3 * P ** 0.2 * A ** (-0.2) - 5 * D,                                # dDdt differential equation for D
        0.16 * B ** 0.25 * 2 ** CF - 0.15 * M ** (2 - 1 * CF)                          # dMdt differential equation for M
    ]
    return dXdt



fig, axs = plt.subplots(2,1)

for i in range(2):
    CF = CF_values[i]
    # events in solve_ivp only detect situations where the event function is zero, does not allow for value alteration. So, the only why to do the perturbations is by starting and stoping the simulation.
    sol_0_20 = solve_ivp(fun, y0=X0, t_span=[0,19.9], max_step = 0.1)       # call solver
    X1 = [3000.,sol_0_20.y[1][-1],sol_0_20.y[2][-1],sol_0_20.y[3][-1],sol_0_20.y[4][-1],sol_0_20.y[5][-1]]
    sol_20_160 = solve_ivp(fun, y0=X1, t_span=[20,159.9], max_step = 0.1)       # call solver
    X2 = [5000.,sol_20_160.y[1][-1],sol_20_160.y[2][-1],sol_20_160.y[3][-1],sol_20_160.y[4][-1],sol_20_160.y[5][-1]]
    sol_160_300 = solve_ivp(fun, y0=X2, t_span=[160,299.9], max_step = 0.1)       # call solver
    # note that the perturbation for B in the next line is 9600 instead of 10000. The latter value would crash the solver.
    X3 = [9600.,sol_160_300.y[1][-1],sol_160_300.y[2][-1],sol_160_300.y[3][-1],sol_160_300.y[4][-1],sol_160_300.y[5][-1]]
    sol_300_400 = solve_ivp(fun, y0=X3, t_span=[300,400], max_step = 0.1)       # call solver

    t = np.concatenate((sol_0_20.t,sol_20_160.t,sol_160_300.t,sol_300_400.t),axis=None)
    B = np.concatenate((sol_0_20.y[0],sol_20_160.y[0],sol_160_300.y[0],sol_300_400.y[0]),axis=None)
    P = np.concatenate((sol_0_20.y[1],sol_20_160.y[1],sol_160_300.y[1],sol_300_400.y[1]),axis=None)
    A = np.concatenate((sol_0_20.y[2],sol_20_160.y[2],sol_160_300.y[2],sol_300_400.y[2]),axis=None)
    H = np.concatenate((sol_0_20.y[3],sol_20_160.y[3],sol_160_300.y[3],sol_300_400.y[3]),axis=None)
    D = np.concatenate((sol_0_20.y[4],sol_20_160.y[4],sol_160_300.y[4],sol_300_400.y[4]),axis=None)
    M = np.concatenate((sol_0_20.y[5],sol_20_160.y[5],sol_160_300.y[5],sol_300_400.y[5]),axis=None)

    # Graph plotting
    axs[i].plot(t, B, label="B")
    axs[i].set_title(CF_title[i])
    axs[i].plot(t, P, label="P")
    axs[i].plot(t, A, label="A")
    axs[i].plot(t, H, label="H")
    axs[i].plot(t, D, label="D")
    axs[i].plot(t, M, label="M")
    axs[i].grid()
    axs[i].set(xlabel='t', ylabel='')
    axs[i].legend(loc="best")

