
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 20., 101)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
S = 100
C = 0
P = 0
SS = 0
X0 = [S, C, P, SS]

Etot = 4
k1 = 1
k1r = 0.3
k2 = 1.5
arg = (Etot,k1,k1r,k2)

def fun(X, t, Etot, k1, k1r, k2):
    S, C, P, SS = X

    E = Etot - C

    dXdt = [
        - k1 * S * E + k1r * C,         # dSdt differential equation for S
        k1 * S * E - (k1r + k2) * C,    # dvdt differential equation for v
        k2 * C,                         # dSSdt differential equation for SS
        5                               # dPdotdt differential equation for Pdot
    ]

    return dXdt

sol = odeint(fun, y0 = X0, t = t, args = arg)        # call solver

S = sol[:, 0]
C = sol[:, 1]
P = sol[:, 2]
SS = sol[:, 3]

fig, axs = plt.subplots(2,1)
# Graph plotting
axs[0].plot(t, S, label="S")
axs[0].plot(t, C, label="C")
axs[0].plot(t, P, label="P")
axs[0].plot(t, SS, label="SS")
axs[0].grid()
axs[0].set(xlabel='t', ylabel='')
axs[0].legend(loc="best")

Vmax = arg[3] * arg[0]
KM = (arg[2] + arg[3]) / arg[1]
v = Vmax * SS / (KM + SS)
Pdot = arg[3] * SS

# Graph plotting
axs[1].plot(SS, v)
axs[1].grid()
axs[1].set(xlabel='SS', ylabel='v')


