
### Fermentation System ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 500., 5001)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
B = 36
E = 60
X0 = [B, E]

mu_max = 5
K1 = 2
K2 = 10
a = 0.01
b = 0.05
c = 0.03
G = 2
arg = (K1,K2,a,b,c,G)

def fun(X, t, K1,K2,a,b,c,G):
    B, E = X

    G = 4 if (t > 100) else G
    G = 2 if (t > 300) else G

    dXdt = [
        mu_max * B * (G / (K1 + G)) * K2 / (K2 + E) - a * B ** 2,       # dBdt differential equation for B
        b * B - c * E                                                   # dEdt differential equation for E
    ]

    return dXdt

sol = odeint(fun, y0 = X0, t = t, args = arg)        # call solver

B = sol[:, 0]
E = sol[:, 1]


# Graph plotting
plt.figure()
plt.plot(t, B, label="B")
plt.plot(t, E, label="E")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()




