
### Linearization ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 50., 501)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
X = 8.660143
Y = 2
XX = 0
YY = 0
x0 = [X, Y, XX, YY]

c1 = 3
c2 = 2
c3 = 5
c4 = 6
c5 = 3
n = 2
arg = (c1,c2,c3,c4,c5,n,x0)


def fun(X, t, c1,c2,c3,c4,c5,n,x0):
    X, Y, XX, YY = X

    Bolus = 0
    Bolus = 5 if (t > 5) else Bolus
    Bolus = 0 if (t > 6) else Bolus

    dXdt = [
        c1 - c2 * Y * X ** n / (c3 ** n + X ** n) + Bolus,  # dXdt differential equation for X
        c4 - c5 * Y,                                        # dYdt differential equation for Y
        -(c2 * x0[1] * 2 * c3 ** 2 * x0[0] / (c3 ** 2 + x0[0] ** 2) ** 2) * XX - (c2 * x0[0] ** 2 / (c3 ** 2 + x0[0] ** 2)) * YY + Bolus,  # dXXdt differential equation for XX
        - c5 * YY                                              # dYYdt differential equation for YY
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

X = sol[:, 0]
Y = sol[:, 1]
XXX = sol[:, 2] + 8.660143
YYY = sol[:, 3] + 2

# Graph plotting
plt.figure()
plt.plot(t, X, label="X")
plt.plot(t, Y, label=" Y")
plt.plot(t, XXX, label="XXX")
plt.plot(t, YYY, label="YYY")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()







