
### Fermentation System ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 300., 3001)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
x1 = 1
x2 = 1
x3 = 1
x4 = 1
x0 = [x1, x2, x3, x4]

r1 = 1
r2 = 0.72
r3 = 1.53
r4 = 1.27
a11 = 1
a12 = 1.09
a13 = 1.52
a14 = 0
a21 = 0
a22 = 1
a23 = 0.44
a24 = 1.36
a31 = 2.33
a32 = 0
a33 = 1
a34 = 0.47
a41 = 1.21
a42 = 0.51
a43 = 0.35
a44 = 1
arg = (r1,r2,r3,r4,a11,a12,a13,a14,a21,a22,a23,a24,a31,a32,a33,a34,a41,a42,a43,a44)

def fun(X, t, r1,r2,r3,r4,a11,a12,a13,a14,a21,a22,a23,a24,a31,a32,a33,a34,a41,a42,a43,a44):
    x1, x2, x3, x4 = X

    dXdt = [
        r1 * x1 * (1 - a11 * x1 - a12 * x2 - a13 * x3 - a14 * x4),  # dx1dt differential equation for x1
        r2 * x2 * (1 - a21 * x1 - a22 * x2 - a23 * x3 - a24 * x4),  # dx2dt differential equation for x2
        r3 * x3 * (1 - a31 * x1 - a32 * x2 - a33 * x3 - a34 * x4),  # dx3dt differential equation for x3
        r4 * x4 * (1 - a41 * x1 - a42 * x2 - a43 * x3 - a44 * x4)   # dx4dt differential equation for x4
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

x1 = sol[:, 0]
x2 = sol[:, 1]
x3 = sol[:, 2]
x4 = sol[:, 3]

# Graph plotting
plt.figure()
plt.plot(t, x1, label="x1")
plt.plot(t, x2, label="x2")
plt.plot(t, x3, label="x3")
plt.plot(t, x4, label="x4")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()







