
### Fermentation System ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 5., 51)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
S = 1
x0 = [S]

def fun(X, t):
    S = X

    dXdt = [
        1           # this just mimics time. I do not understand this.
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t)        # call solver

S = sol[:, 0]

vmax = 1
km = 2
vmm = vmax * S / (km + S)

OP = 2
f = km / (km + OP)
gam = (vmax * OP / (km + OP)) * OP ** (-f)
pl = gam * S ** f

# Graph plotting
plt.figure()
plt.plot(t, vmm, label="line vmm")
plt.plot(t, pl, label="line pl")
plt.grid()
plt.legend(loc="best")
plt.xlabel('t')
plt.show()




