
### MonteCarloPops ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 50., 501)    # time spacing # ((tmax-tmin)/step)+1

r1 = 0.2
K1 = 50
a = 0.2
r2 = 0.4
K2 = 25
b = 0.25
arg = (r1,K1,a,r2,K2,b)

def fun(X, t, r1,K1,a,r2,K2,b):
    N1, N2 = X

    dXdt = [
        r1 * (K1 - N1 - a * N2) * N1 / K1,  # dx1dt differential equation for N1
        r2 * (K2 - N2 - b * N1) * N2 / K2  # dx2dt differential equation for N2
    ]

    return dXdt


initals_N1 = initals_N2 = finals_N1 = finals_N2 = [1,2,3,4,5,6,7,8,9,10]

# Graph plotting
plt.figure()
for i in range(10):
    # initial conditions
    initals_N1[i] = N1 = 100 * np.random.random(1)[0]
    initals_N2[i] = N2 = 50 * np.random.random(1)[0]
    x0 = [N1, N2]
    sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver
    finals_N1[i] = sol[len(sol)-1,0]
    finals_N2[i] = sol[len(sol)-1,1]

    x1 = sol[:, 0]
    x2 = sol[:, 1]
    if i == 1:
        plt.plot(t, x1, color='#0000ff', label="N1")
        plt.plot(t, x2, color='#FF0000', label="N2")
    else:
        plt.plot(t, x1, color='#0000ff')
        plt.plot(t, x2, color='#FF0000')


plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()




