
### Pop1 ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 100., 501)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

# initial conditions
N1 = 2
N2 = 50
x0 = [N1, N2]

r1 = 0.2
K1 = 50
a = 0.2
r2 = 0.4
K2 = 25
b = 0.25
arg = (r1,K1,a,r2,K2,b)


def fun(X, t, r1,K1,a,r2,K2,b):
    N1, N2 = X

    dXdt = [
        r1 * (K1 - N1 - a * N2) * N1 / K1,  # dx1dt differential equation for N1
        r2 * (K2 - N2 - b * N1) * N2 / K2   # dx2dt differential equation for N2
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

N1 = sol[:, 0]
N2 = sol[:, 1]

# Graph plotting
plt.figure()
plt.plot(t, N1, label="N1")
plt.plot(t, N2, label="N2")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()







