
### reverse ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 365., 3651)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

# initial conditions
S = 990
I = 10
R = 0
x0 = [S, I, R]

b = 3
r = .01
e = 0.0005 * 1  # 0.2
lam = .05
d = .02
arg = (b,r,e,lam,d)

def fun(X, t, b,r,e,lam,d):
    S, I, R = X

    dXdt = [
        b + r * R - e * S * I,                  # dS/dt
        e * S * I - lam * I - d * I,            # dI/dt
        lam * I - r * R                         # dR/dt
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

S = sol[:, 0]
I = sol[:, 1]
R = sol[:, 2]

# Graph plotting
plt.figure()
plt.plot(t, S, label="S")
plt.plot(t, I, label="I")
plt.plot(t, R, label="R")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()


fig, axs = plt.subplots(2,1)
# Graph plotting
axs[0].plot(t, S, label="line S")
axs[0].plot(t, I, label="line I")
axs[0].plot(t, R, label="line P")
axs[0].grid()
axs[0].set(xlabel='t', ylabel='')
axs[0].legend(loc="best")


### SIRQ ###

# initial conditions
S = 990
I = 10
R = 0
Q = 0
x0 = [S, I, R, Q]

b = 3
r = .01
e = 0.0005 * 1  # 0.2
lam = .05
d = .02
q = .1  # quarantine
arg = (b,r,e,lam,d,q)

def fun(X, t, b,r,e,lam,d,q):
    S, I, R, Q = X

    dXdt = [
        b + r * R - e * S * I,  # dS/dt
        e * S * I - lam * I - d * I - q * I,  # dI/dt
        lam * I + lam * Q - r * R,  # dR/dt
        q * I - lam * Q - d * Q  # dQ/dt
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

S = sol[:, 0]
I = sol[:, 1]
R = sol[:, 2]
Q = sol[:, 3]

# Graph plotting
plt.figure()
plt.plot(t, S, label="S")
plt.plot(t, I, label="I")
plt.plot(t, R, label="R")
plt.plot(t, Q, label="Q")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()

# Graph plotting
axs[1].plot(t, S, label="line S")
axs[1].plot(t, I, label="line I")
axs[1].plot(t, R, label="line P")
axs[1].plot(t, Q, label="line Q")
axs[1].grid()
axs[1].set(xlabel='t', ylabel='')
axs[1].legend(loc="best")
















