
### stabilityHW ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 0.5, 2)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

r1 = 0.2
K1 = 50
a = 0.2
r2 = 0.4
K2 = 25
b = 0.25
arg = (r1, K1, a, r2, K2, b)

def fun(X, t, r1, K1, a, r2, K2, b):
    N1, N2 = X

    dXdt = [
            r1 * (K1 - N1 - a * N2) * N1 / K1,      # dN1/dt
            r2 * (K2 - N2 - b * N1) * N2 / K2       # dN2/dt
    ]

    return dXdt

plt.figure()
plt.xlabel('N1')
plt.ylabel('N2')
plt.grid()
for i in range(20):
    for j in range(20):
        # initial conditions
        N1 = 5 * (i+1)
        N2 = 2.5 * (j+1)
        x0 = [N1, N2]
        sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver
        N1 = sol[:, 0]
        N2 = sol[:, 1]
        #plt.plot(N1, N2,'b')    # Graph plotting
        plt.arrow(x=N1[0], y=N2[0], dx=N1[1]-N1[0], dy=N2[1]-N2[0], width=0.1)

plt.show()

