
### predatorPrey ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 100., 501)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

# initial conditions
prey = 10
pred = 1
x0 = [prey, pred]

def fun(X, t):
    prey, pred = X

    dXdt = [
        1.5 * prey - 0.2 * prey * pred,  # dpreydt differential equation for prey
        0.015 * prey * pred - 0.2 * pred  # dpreddt differential equation for pred
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t)        # call solver

prey = sol[:, 0]
pred = sol[:, 1]


plt.plot(t, sol[:, 0], 'b', t, sol[:, 1], 'r')
plt.legend(['prey', 'pred'])
plt.xlabel('Time')
plt.ylabel('Population')
plt.show()