
### predatorPrey ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 2000., 20001)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

# initial conditions
P = 5
I = 400
G = 100
H = 10
X1 = 5
U = 100
x0 = [P, I, G, H, X1, U]

k1 = 320
k2 = 0.5
k3 = 0.3
k4 = 1.2
k5 = 2
k6 = 12
k7 = 0.01
k8 = 0.1
k9 = 0.75
k10 = 0.004
k11 = 1.4
k12 = 0.031
vIn = 5
arg = (k1,k2,k3,k4,k5,k6,k7,k8,k9,k10,k11,k12,vIn)

def fun(X, t, k1,k2,k3,k4,k5,k6,k7,k8,k9,k10,k11,k12,vIn):
    P, I, G, H, X1, U = X

    vPG = k1 * P ** 1.2 * G ** (-1.2)
    vPI = k2 * P ** 2 * I ** (-0.6)
    vPH = k3 * P ** 0.5;
    vPHI = k4 * P * I ** (-0.5) * H ** 0.5
    vIG = k5 * I ** 0.2 * G ** (-0.2)
    vGI = k6 * G ** 0.7 * I ** (-1.2)
    vGX = k7 * G ** 0.5
    vIH = k8 * I ** 0.8
    vHX = k9 * H ** 0.6
    vHout = k10 * H
    vXU = k11 * X1 ** 0.5
    vUout = k12 * U ** 1

    dXdt = [
            vIn - vPG - vPH - vPI - vPHI,       # dPdt
            vPI + vPHI + vGI - vIG - vIH,       # dIdt
            vPG + vIG - vGI - vGX,              # dGdt
            vPH + vIH - vPHI - vHX - vHout,     # dHdt
            vGX + vHX - vXU,                    # dX1dt
            vXU - vUout                         # dUdt
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

P = sol[:, 0]
I = sol[:, 1]
G = sol[:, 2]
H = sol[:, 3]
X1 = sol[:, 4]
U = sol[:, 5]


# Graph plotting
plt.figure()
plt.plot(t, P, label="P")
plt.plot(t, I, label="I")
plt.plot(t, G, label="G")
plt.plot(t, H, label="H")
plt.plot(t, X1, label="X")
plt.plot(t, U, label="U")
plt.grid()
plt.xlabel('t')
plt.legend(loc="best")
plt.show()