
### reverse ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 20., 201)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

# initial conditions
X1 = 2
X2 = 4
X3 = 3
X4 = 0.5
x0 = [X1, X2, X3, X4]

X0 = 1
a1 = 5
b1 = .6
b2 = 1.2
b3 = 0.8
b4 = 2
c1 = 3
r1 = 0
r2 = 0
g = -0.1
h = .5
arg = (X0,a1,b1,b2,b3,b4,c1,r1,r2,g,h)

def fun(X, t, X0,a1,b1,b2,b3,b4,c1,r1,r2,g,h):
    X1, X2, X3, X4 = X

    dXdt = [
        a1 * X0 * X3 ** g - b1 * X1 - c1 * X1 ** .5 + r1 * X2 ** .5,       # dX1/dt
        b1 * X1 - b2 * X2 ** .4 - r1 * X2 ** .5 + r2 * X3 ** .5,           # dX2/dt
        b2 * X2 ** .4 - b3 * X3 ** h - r2 * X3 ** .5,                      # dX3/dt
        c1 * X1 ** .5 - b4 * X4 ** .8                                     # dX4/dt
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t, args = arg)        # call solver

X1 = sol[:, 0]
X2 = sol[:, 1]
X3 = sol[:, 2]
X4 = sol[:, 3]

# Graph plotting
plt.figure()
plt.plot(t, X1, label="X1")
plt.plot(t, X2, label="X2")
plt.plot(t, X3, label="X3")
plt.plot(t, X4, label="X4")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()



