
### simplifiedMAPK ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
from scipy.integrate import solve_ivp
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 10., 101)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
X1 = 9
X1P = 1
X2 = 9
X2P = 1
X3 = 9
X3P = 1
X0 = [X1, X1P, X2, X2P, X3, X3P]

a1 = 10
b1 = 0.1
a2 = 10
b2 = 4
a3 = 10
b3 = 4
arg = (a1,b1,a2,b2,a3,b3)

def fun(X,t, a1,b1,a2,b2,a3,b3):
    X1, X1P, X2, X2P, X3, X3P = X

    S = 1
    S = 200 if (t > 4) else S
    S = 1 if (t > 8) else S

    dXdt = [
        a1 * X1P - b1 * X1 * S,  # dX1/dt
        b1 * X1 * S - a1 * X1P,  # dX1P/dt
        a2 * X2P - b2 * X2 * X1P,  # dX2/dt
        b2 * X2 * X1P - a2 * X2P,  # dX2P/dt
        a3 * X3P - b3 * X3 * X2P,  # dX3/dt
        b3 * X3 * X2P - a3 * X3P  # dX3P/dt
    ]
    return dXdt

sol = odeint(fun, y0 = X0, t = t, args = arg)        # call solver

X1 = sol[:, 0]
X1P = sol[:, 1]
X2 = sol[:, 2]
X2P = sol[:, 3]
X3 = sol[:, 4]
X3P = sol[:, 5]

# Graph plotting
plt.figure()
plt.plot(t, X1, label="X1")
plt.plot(t, X1P, label="X1P")
plt.plot(t, X2, label="X2")
plt.plot(t, X2P, label="X2P")
plt.plot(t, X3, label="X3")
plt.plot(t, X3P, label="X3P")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()