
### stabilityHW ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 20., 201)    # time spacing # ((tmax-tmin)/step)+1 # t = np.arange(t0, tf + 1)

# initial conditions
P1 = 2
P2 = 4
x0 = [P1, P2]

def fun(X, t):
    P1, P2 = X

    dXdt = [
        2 * P1 ** (-1) * P2 ** (-2) - 2 * P1 ** 2 * P2 ** 4,    # dP1/dt
        4 * P1 ** 2 * P2 - 4                                 # dP2/dt
    ]

    return dXdt

sol = odeint(fun, y0 = x0, t = t)        # call solver

P1 = sol[:, 0]
P2 = sol[:, 1]

# Graph plotting
plt.figure()
plt.plot(t, P1, label="P1")
plt.plot(t, P2, label="P2")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()

