
### twoComp ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
from scipy.integrate import solve_ivp
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 48., 481)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
B = 0.01        # 0
L = 0.01        # 0
X0 = [B,L]

k0B = 0
kLB = .5
kB0 = .9
kBL = .8
kL0 = .3
arg = (k0B,kLB,kB0,kBL,kL0)

def fun(X,t, k0B,kLB,kB0,kBL,kL0):
    B, L = X

    IN = 0
    IN = 10 if (t > 8) else IN
    IN = 0 if (t > 8.4) else IN     # t > 8.1

    dXdt = [
        k0B + kLB * L - (kB0 + kBL) * B + IN,   # dB/dt
        kBL * B - (kL0 + kLB) * L               # dL/dt
    ]
    return dXdt

sol = odeint(fun, y0 = X0, t = t, args = arg)        # call solver

B = sol[:, 0]
L = sol[:, 1]

# Graph plotting
plt.figure()
plt.plot(t, B, label="B")
plt.plot(t, L, label="L")
plt.xlabel('t')
plt.legend(loc="best")
plt.grid()
plt.show()



