%% MATLAB_BLUES_Chapter_4_v4012.m

%% 4.1.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
most_typical_student=4;
scores=mu + randn(n_students,1)*sigma
criterion=scores(most_typical_student)
average_score=mean(scores)
if average_score>criterion
    training_method==1
else
    training_method==2
end

%% 4.1.5 Solved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
most_typical_student=4;
scores=mu + randn(n_students,1)*sigma
criterion=scores(most_typical_student)
average_score=mean(scores)
if average_score<=criterion
    training_method=1
else
    training_method=2
end

%% 4.2.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
most_typical_student=4;
scores= mu + randn(n_students,1)*sigma
criterion=scores(most_typical_student)
for si=1:n_students
    if scores(si)<criterion
        training_method=1;
    else
        training_method=2;
    end
    scores(si)=[scores(si) training_method];
    scores
end
scores

%% 4.2.5 Solved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
most_typical_student=4;
scores= mu + randn(n_students,1)*sigma
criterion=scores(most_typical_student)
for si=1:n_students
    if scores(si)<criterion
        training_method=1;
    else
        training_method=2;
    end
    scores_plus(si,:)=[scores(si,1) training_method];
end
scores_plus

%% 4.3.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_students=20;
scores_plus =[
    88.8551    2.0000
    81.1064    2.0000
    93.6519    2.0000
    78.5192    2.0000
    82.8215    2.0000
    87.9131    2.0000
    93.6462    2.0000
    81.5178    2.0000
    76.0487    1.0000
    84.0169    2.0000
    73.4005    1.0000
    78.6308    2.0000
    81.3593    2.0000
    87.4478    2.0000
    87.1857    2.0000
    79.8622    2.0000
    84.6197    2.0000
    78.3936    1.0000
    83.3056    2.0000
    89.5765    2.0000
    ]

for si=1:n_students
    decile_group=NaN;
    for decile=0:9
        cutoff(decile+1)=min(scores_plus(:,1)) + ...
            ((decile*.1)*(max(scores_plus(:,1))-min(scores_plus(:,1))));
        if scores_plus(si,1)>cutoff(decile+1)
            decile_group=decile+1;
        end
        scores_plus_plus(si,:)=[scores_plus(si,:) decile_group];
    end
end
cutoff
scores_plus_plus


%% 4.3.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_students=20;
scores_plus =[
    88.8551    2.0000
    81.1064    2.0000
    93.6519    2.0000
    78.5192    2.0000
    82.8215    2.0000
    87.9131    2.0000
    93.6462    2.0000
    81.5178    2.0000
    76.0487    1.0000
    84.0169    2.0000
    73.4005    1.0000
    78.6308    2.0000
    81.3593    2.0000
    87.4478    2.0000
    87.1857    2.0000
    79.8622    2.0000
    84.6197    2.0000
    78.3936    1.0000
    83.3056    2.0000
    89.5765    2.0000
    ]
for si=1:n_students
    decile_group=NaN;
    for decile=0:9
        cutoff(decile+1)=min(scores_plus(:,1)) + ((decile*.1)*(max(scores_plus(:,1))-min(scores_plus(:,1))));
        if scores_plus(si,1)>=cutoff(decile+1)
            decile_group=decile+1;
        end
        scores_plus_plus(si,:)=[scores_plus(si,:) decile_group];
    end
end
cutoff
scores_plus_plus

%% 4.4.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_students=20;
basic_proportion=.05;
n_tiles=basic_proportion;
scores_plus =[
    88.8551    2.0000
    81.1064    2.0000
    93.6519    2.0000
    78.5192    2.0000
    82.8215    2.0000
    87.9131    2.0000
    93.6462    2.0000
    81.5178    2.0000
    76.0487    1.0000
    84.0169    2.0000
    73.4005    1.0000
    78.6308    2.0000
    81.3593    2.0000
    87.4478    2.0000
    87.1857    2.0000
    79.8622    2.0000
    84.6197    2.0000
    78.3936    1.0000
    83.3056    2.0000
    89.5765    2.0000
    ]
scores_plus_plus=[];
for si=1:n_students
    n_tile_group=NaN;
    for n_tile=0:n_tiles-1
        cutoff(n_tile+1)=min(scores_plus(:,1)) + ...
            ((n_tile*basic_proportion)*(max(scores_plus(:,1))-min(scores_plus(:,1))));
        if scores_plus(si,1)>=cutoff(n_tile+1)
            n_tile_group=n_tile+1;
        end
        scores_plus_plus(si,:)=[scores_plus(si,:) n_tile_group];
    end
end
scores_plus_plus
scores_plus_plus_sorted=sortrows(scores_plus_plus,2)

%% 4.4.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_students=20;
basic_proportion=.05;
n_tiles=1/basic_proportion;
if rem(n_tiles,1)~=0
    disp('Oops. n_tiles is not an integer')
    disp('Hit ctrl-c to quit and fix the program.')
    pause
end
scores_plus =[
    88.8551    2.0000
    81.1064    2.0000
    93.6519    2.0000
    78.5192    2.0000
    82.8215    2.0000
    87.9131    2.0000
    93.6462    2.0000
    81.5178    2.0000
    76.0487    1.0000
    84.0169    2.0000
    73.4005    1.0000
    78.6308    2.0000
    81.3593    2.0000
    87.4478    2.0000
    87.1857    2.0000
    79.8622    2.0000
    84.6197    2.0000
    78.3936    1.0000
    83.3056    2.0000
    89.5765    2.0000
    ]
scores_plus_plus=[];
for si=1:n_students
    n_tile_group=NaN;  % default assignment
    for n_tile=0:n_tiles-1
        cutoff(n_tile+1)=min(scores_plus(:,1)) + ...
            ((n_tile*basic_proportion)*(max(scores_plus(:,1))-min(scores_plus(:,1))));
        if scores_plus(si,1)>=cutoff(n_tile+1)
            n_tile_group=n_tile+1;
        end
        scores_plus_plus(si,:)=[scores_plus(si,:) n_tile_group];
    end
end
scores_plus_plus
scores_plus_plus_sorted=sortrows(scores_plus_plus,-3)

%% 4.5.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

interest_rate=.04;
t=1;
money(t)=1;
finance_record(1,1:2)=[t money(t)];
money_doubled=false;
while money_doubled==false
    t=t+1
    money(t)=money(t-1)*(1+interest_rate);
    if money(t)==2*money(1)
        money_doubled=true;
    end
    finance_record(t,1:2)=[t money(t)];
end
finance_record

%% 4.5.5 Solved Problem Code
clear all
close all
commandwindow
clc

interest_rate=.04;
t=1;
money(t)=1;
finance_record(1,1:2)=[t money(t)];
money_doubled=false;
while money_doubled==false
    t=t+1
    money(t)=money(t-1)*(1+interest_rate);
    if money(t)>=2*money(1)
        money_doubled=true;
    end
    finance_record(t,1:2)=[t money(t)];
end
finance_record

%% 4.6.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

M = [
    4     7     1     7
    4     3     6     2
    10    7     8     7
    7     1     5     8
    10    1     6     6
    10   10     9     3
    1     6     6     5
    5    10     1     9
    8     7     6     3
    4     6     7     7
    ]
criterion=7;
good_M=[];
for ri=1:size(M,1)
    for ci=1:size(M,2)
        if (M(ri,ci)>=criterion)
            good_M=[good_M; M(ri,:)];
        end
    end
end
M
good_M
size_of_M=size(M)
size_of_good_M=size(good_M)

%% 4.6.5 Solved Problem Code
clear all
close all
commandwindow
clc
M = [
    4     7     1     7
    4     3     6     2
    10    7     8     7
    7     1     5     8
    10    1     6     6
    10   10     9     3
    1     6     6     5
    5    10     1     9
    8     7     6     3
    4     6     7     7
    ]
criterion=7;
good_M=[];
for ri=1:size(M,1)
    for ci=1:size(M,2)
        if (M(ri,ci)>=criterion)
            good_M=[good_M; M(ri,:)];
            break  % break out of the for loop if you got here.
        end
    end
end
M
good_M
size_of_M=size(M)
size_of_good_M=size(good_M)


%% 4.7.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_subjects=6;   % should be the same as n_conditions for Latin square
n_conditions=6; % should be the same as n_subjects for Latin square
for si=1:n_subjects
    if si==1  % subject 1
        order(si,1:n_conditions)=randperm(n_conditions);
    else  % subject > 1
        for ci=1:n_conditions-1
            order(si,ci)=order(si-1,ci+1); % inherit the condition from above and to the right
        end
        order(si,ci)=order(si-1,1);  % inherit the first condition from the last subject
    end
end
order
reversed_order=order(:,end:-1:1)
combined_order=[order;reversed_order]
design=[[1:size(combined_order,1)]' combined_order]

%% 4.7.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_subjects=6;   % should be the same as n_conditions for Latin square
n_conditions=6; % should be the same as n_subjects for Latin square
for si=1:n_subjects
    if si==1   % subject 1
        order(si,1:n_conditions)=randperm(n_conditions);
    else    % subject > 1
        for ci=1:n_conditions-1
            order(si,ci)=order(si-1,ci+1); % inherit the condition from above and to the right
        end
        order(si,n_conditions)=order(si-1,1); % inherit the first condition from the last subject
    end
end
order
reversed_order=order(:,end:-1:1)
combined_order=[order;reversed_order]
design=[[1:size(combined_order,1)]' combined_order]

%% 4.8.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

full_design=[];
n_subjects=6;
n_conditions=6;
n_groups=12;
perm_order=[];
for gi=1:n_groups
    new_group_OK=false;
    while new_group_OK==false
        for si=1:n_subjects
            if si==1
                order(si,1:n_conditions)=randperm(n_conditions);
            else
                for ci=1:n_conditions-1
                    order(si,ci)=order(si-1,ci+1);
                end
                order(si,n_conditions)=order(si-1,1);
            end
        end
        new_group_OK=true;
        group_column(1:n_subjects)=gi;
        subject_column=[1:n_subjects];
        perm_order=[perm_order; full_design;[group_column' subject_column' order]];
    end
end
perm_order

%% 4.8.5 Solved Problem Code
clear all
close all
commandwindow
clc

full_design=[];
n_subjects=6;
n_conditions=6;
n_groups=12;
perm_order=[];
for gi=1:n_groups
    new_group_OK=false;
    while new_group_OK==false
        match=0;
        for si=1:n_subjects
            if si==1
                order(si,1:n_conditions)=randperm(n_conditions);
            else
                for ci=1:n_conditions-1
                    order(si,ci)=order(si-1,ci+1);
                end
                order(si,n_conditions)=order(si-1,1);
            end
        end
        % check to make sure the proposed order for this subject doesn't
        % repeat a previous order within this group
        if si>1
            for a=1:size(order,1)-1
                for b=2:size(perm_order,1)
                    if a==b(:,2:end)
                        match=match+1;
                        break
                    end
                end
            end
        end
        if match==0
            new_group_OK=true;
            group_column(1:n_subjects)=gi;
            subject_column=[1:n_subjects];
            perm_order=[perm_order; full_design;[group_column' subject_column' order]];
        end
    end
end
perm_order

%% 4.9.2 Unsolved Problem Code
clear all
close all
commandwindow
clc
rows_per_M=5000.*[1:5];  % the rows_per_M will be 5,000, 10,000, 20,000, ..., 60,000
final_row_numbers_per_M=size(rows_per_M,2); % or 5 in this instance
columns_per_M=4;
columns_per_summary=2;
max_randi=10;
criterion_sum=5;
summary(1:final_row_numbers_per_M,1:columns_per_summary)=NaN;
for nri=1:final_row_numbers_per_M
    tic
    M=randi(max_randi,rows_per_M(nri),columns_per_M);
    good_M=[];
    for ri=1:rows_per_M(nri)
        if M(ri,2)+M(ri,3)>=criterion_sum
            good_M=[good_M; M(ri,:)];
        end
    end
    M;
    good_M;
    size_of_M=size(M);
    size_of_good_M=size(good_M);
    summary(nri,1:2)=[nri tic]
end  % for nri=1:size(n_rows,2)

%% 4.9.5 Solved Problem Code
clear all
close all
commandwindow
clc
rows_per_M=5000.*[1:5];  % the rows_per_M will be 5,000, 10,000, 15,000, 20,000, 25,000
final_row_numbers_per_M=size(rows_per_M,2); % or 5 in this instance
columns_per_M=4;
columns_per_summary=2;
max_randi=10;
criterion_sum=5;
summary(1:final_row_numbers_per_M,1:columns_per_summary)=NaN;
for nri=1:final_row_numbers_per_M
    tic
    M=randi(max_randi,rows_per_M(nri),columns_per_M);
    good_M=[];
    for ri=1:rows_per_M(nri)
        if M(ri,2)+M(ri,3)>=criterion_sum
            good_M=[good_M; M(ri,:)];
        end
    end
    M;
    good_M;
    size_of_M=size(M);
    size_of_good_M=size(good_M);
    summary(nri,1:2)=[nri toc]
end  % for nri=1:size(n_rows,2)
summary

%% 4.10.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

rows_per_M=10000.*[1:5];  % the rows_per_M will be 10,000, 20,000, ..., 50,000; 
final_row_numbers_per_M=length(rows_per_M); % or 5 in this instance
columns_per_M=4;
columns_per_summary=2;
max_randi=10;
criterion_sum=5;
summary(1:final_row_numbers_per_M,1:columns_per_summary)=NaN;
for nri=1:final_row_numbers_per_M
    tic
    M=randi(max_randi,rows_per_M(nri),columns_per_M);
    good_M=[];
    for ri=1:rows_per_M(nri)
        if M(ri,2)+M(ri,3)>=criterion_sum
            good_M=[good_M; M(ri,:)];
        end
    end
    M;
    good_M;
    size_of_M=size(M);
    size_of_good_M=size(good_M);
    summary(nri,1:2)=[nri toc]
end  % for nri=1:size(n_rows,2)

%% 4.10.5 Solved Problem Code
clear all
close all
commandwindow
clc

rows_per_M=10000.*[1:5];  % the rows_per_M will be 10,000, 20,000, ..., 50,000; 
final_row_numbers_per_M=length(rows_per_M); % or 5 in this instance
columns_per_M=4;
columns_per_summary=2;
max_randi=10;
criterion_sum=5;
summary(1:final_row_numbers_per_M,1:columns_per_summary)=NaN;
for nri=1:final_row_numbers_per_M
    tic
    M=randi(max_randi,rows_per_M(nri),columns_per_M);
    good_M=[];
    good_rows=find(M(:,3)+M(:,4)>=criterion_sum);
    good_M=M(good_rows,:);
    M;
    good_M;
    size_of_M=size(M);
    size_of_good_M=size(good_M);
    summary(nri,1:2)=[nri toc];
end  % for nri=1:size(n_rows,2)
summary
