%% MATLAB_BLUES_Chapter_5_Code_v5004.m

%% 5.1.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(1)
x=[0:20];
k=2;
y=k*x;
plot(x,'o-')

%% 5.1.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(2)
x=[0:20];
k=2;
y=k*x;
plot(x,y,'o-')

%% 5.2.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(3)
x=[0:20];
k=[1 3];
for ki=1:size(k,2)
    y=k(ki)*x;
    plot(x,y,'o-')
end

%% 5.2.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(4)
hold on
x=[0:20];
k=[1 3];
for ki=1:size(k,2)
    y=k(ki)*x;
    plot(x,y,'o-')
end

%% 5.3.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

x_means=[.1:.1:.4];
x_standard_errors=x_means/10;
y_means=[1:4];
y_standard_errors= y_means./10;
figure(5)
hold on

% Define the limits of the x axis and y axis.
kx=.1;
ky=.1;
xlim_bottom=[min(x_means-x_standard_errors)];
xlim_top=[max(x_means+x_standard_errors)];
xlim_top=xlim_top + (xlim_top-xlim_bottom)*kx;
xlim_bottom=xlim_bottom -(xlim_top-xlim_bottom)*kx;
ylim_bottom=[min(y_means-y_standard_errors)];
ylim_top=[max(y_means+y_standard_errors)];
ylim_top=ylim_top + (ylim_top-ylim_bottom)*ky;
ylim_bottom=ylim_bottom -(ylim_top-ylim_bottom)*ky;

xlim([xlim_bottom xlim_top]);
ylim([ylim_bottom ylim_top]);

% Define markersize, ms, computationally rather than by hand
kms=750;
ms=kms*min([x_standard_errors y_standard_errors]);

% Make the graph
plot(x_means,y_means,'ko','markerfacecolor','g','markersize',ms)

errorbar(x_means,y_means,y_standard_errors,'k')
errorbar(x_means,y_means,x_standard_errors,'k','horizontal')

set(gca,'xtick',x_means);
set(gca,'ytick',y_means);
box on
axis square

%% 5.3.5 Solved Problem Code
clear all
close all
commandwindow
clc

x_means=[.1:.1:.4];
x_standard_errors=x_means/10;
y_means=[1:4];
y_standard_errors= y_means./10;

figure(6)
hold on
errorbar(x_means,y_means,y_standard_errors,'k')
errorbar(x_means,y_means,x_standard_errors,'k','horizontal')

% Define the limits of the x axis, xlim, and  the limits of the y axis, ylim.
kx=.1;
ky=.1;
xlim_bottom=[min(x_means-x_standard_errors)];
xlim_top=[max(x_means+x_standard_errors)];
xlim_top=xlim_top + (xlim_top-xlim_bottom)*kx;
xlim_bottom=xlim_bottom -(xlim_top-xlim_bottom)*kx;

ylim_bottom=[min(y_means-y_standard_errors)];
ylim_top=[max(y_means+y_standard_errors)];
ylim_top=ylim_top + (ylim_top-ylim_bottom)*ky;
ylim_bottom=ylim_bottom -(ylim_top-ylim_bottom)*ky;

xlim([xlim_bottom xlim_top]);
ylim([ylim_bottom ylim_top]);

% Define markersize. ms, computationally rather than by hand
kms=750;
ms=kms*min([x_standard_errors y_standard_errors]);

% Make the graph
plot(x_means,y_means,'ko','markerfacecolor','g','markersize',ms)
set(gca,'xtick',x_means);
set(gca,'ytick',y_means);
box on
axis square

%% 5.4.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(7)
hold on
xlim_offset=0;
ms=14; % markersize
x=[1:101];
alpha=[-.5 -1];
max_salary=10;
legend_font_size=12;
for ai=1:size(alpha,2)
    y=max_salary*x.^alpha(ai);
    if ai==1
        plot(x,y,'b.-','markersize', ms, 'displayname','Company A');
    else
        plot(x,y,'r.-','markersize', ms, 'displayname','Company B');
    end
end
xlim([min(x)-xlim_offset max(x)+xlim_offset])
legend('show','location','northeast')
get(legend)
set(legend,'FontSize',legend_font_size,'color','w') %[1 1 1]*1)
set(gca,'xtick',[1:10:101])
set(gca,'xticklabel',[1:10:101])
set(gca,'ytick',[0:10])
set(gca,'yticklabel',[0:25:100])
xlabel('Income Rank')
ylabel('Salary (thousands of dollars)')

%% 5.4.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(8)
hold on
xlim_offset=0;
ms=14; % markersize
x=[1:101];
alpha=[-.5 -1];
max_salary=10;
legend_font_size=12;

for ai=1:size(alpha,2)
    y=max_salary*x.^alpha(ai);
    if ai==1
        plot(x,y,'b.-','markersize', ms, 'displayname','Company A');
    else
        plot(x,y,'r.-','markersize', ms, 'displayname','Company B');
    end
end
xlim([min(x)-xlim_offset max(x)+xlim_offset])
legend('show','location','northeast')
get(legend)
set(legend,'FontSize',legend_font_size,'color','w') %[1 1 1]*1)
set(gca,'xtick',[1:10:101])
set(gca,'xticklabel',[1:10:101])

% BAD CODE from before, which was bad because there were fewer ytick values
% than yticklabels.
% set(gca,'ytick',[0:10])
% GOOD CODE FOLLOWS
set(gca,'ytick',[0:2.5:10])

set(gca,'yticklabel',[0:25:100])
xlabel('Income Rank')
ylabel('Salary (thousands of dollars)')

%% 5.5.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(9)
legend_font_size=9;

subplot(2,2,1)
hold on
box on
xlim_offset=0;
dot_markersize=14;
rds=.3;
ring_markersize=round(dot_markersize*rds); % can't have decimals, so round
x=[1:101];
alpha=[-.5 -1];
max_salary=10;
fs=8;
for ai=1:size(alpha,2)
    sy(ai,x)=max_salary*x.^alpha(ai);
    if ai==1
        plot(x,sy(ai,:),'b.-','markersize',dot_markersize, ...
            'displayname','Company A');
    else
        plot(x,sy(ai,:),'ro-','markersize',ring_markersize, ...
            'markerfacecolor','w','displayname','Company B');
    end
end
legend('show','location','north')
get(legend)
set(legend,'FontSize',legend_font_size,'color','w') %[1 1 1]*1)
xlabel('Income Rank')
ylabel('Salary (thousands of dollars)')
set(gca,'xtick',[1:10:101])
set(gca,'xticklabel',[1:10:100])
set(gca,'ytick',[0:2.5:10])
set(gca,'yticklabel',[0:25:100])
xlim([min(x)-xlim_offset max(x)+xlim_offset])

subplot(2,2,2)
hold on
box on
xlim_offset=0;
ms=14; % markersize
x=[1:101];
fc=[.2 .4];
max_salary=10;
fs=12;
for fci=1:size(fc,2)
    fy(fci,x)=fc(fci)*log(x);
    if fci==1
        plot(x,fy(fci,:),'b.-','markersize',dot_markersize,...
            'displayname','Company A');
    else
        plot(x,fy(fci,:),'ro-','markersize',ring_markersize, ...
            'markerfacecolor','w','displayname','Company B');
    end
end
legend('show','location','southeast')
get(legend)
set(legend,'FontSize',legend_font_size,'color','w') %[1 1 1]*1)
xlabel('Income Rank')
ylabel('Friendship')
set(gca,'xtick',[1:10:101])
set(gca,'xticklabel',[1:10:101])
xlim([min(x)-xlim_offset max(x)+xlim_offset])

subplot(3:4)
hold on
box on
plot(sy(1,:),fy(1,:), 'ro',...
    'markersize',ring_markersize,'markerfacecolor','w')
plot(sy(2,:),fy(2,:),'b.-',sy(1,:),fy(1,:),'k-');
set(gca,'xtick',[0:2.5:10])
set(gca,'xticklabel',[0:25:100])
xlabel('Salary (thousands of dollars)')
ylabel('Friendship')
saveas(figure(10),'Fig_Salaries.tif')

%% 5.5.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(10)
legend_font_size=9;
subplot(2,2,1)
hold on
box on
xlim_offset=0;
dot_markersize=14;
rds=.3;
ring_markersize=round(dot_markersize*rds); % can't have decimals, so round
x=[1:101];
alpha=[-.5 -1];
max_salary=10;
fs=8;
for ai=1:size(alpha,2)
    sy(ai,x)=max_salary*x.^alpha(ai);
    if ai==1
        plot(x,sy(ai,:),'b.-','markersize',dot_markersize,...
            'displayname','Company A');
    else
        plot(x,sy(ai,:),'ro-','markersize',ring_markersize,...
            'markerfacecolor','w','displayname','Company B');
    end
end
legend('show','location','north')
get(legend)
set(legend,'FontSize',legend_font_size,'color','w') %[1 1 1]*1)
xlabel('Income Rank')
ylabel('Salary (thousands of dollars)')
set(gca,'xtick',[1:10:101])
set(gca,'xticklabel',[1:10:100])
set(gca,'ytick',[0:2.5:10])
set(gca,'yticklabel',[0:25:100])
xlim([min(x)-xlim_offset max(x)+xlim_offset])

subplot(2,2,2)
hold on
box on
xlim_offset=0;
ms=14; % markersize
x=[1:101];
fc=[.2 .4];
max_salary=10;
fs=12;
for fci=1:size(fc,2)
    fy(fci,x)=fc(fci)*log(x);
    if fci==1
        plot(x,fy(fci,:),'b.-','markersize',dot_markersize,...
            'displayname','Company A');
    else
        plot(x,fy(fci,:),'ro-','markersize',ring_markersize,...
            'markerfacecolor','w','displayname','Company B');
    end
end
legend('show','location','southeast')
get(legend)
set(legend,'FontSize',legend_font_size,'color','w') %[1 1 1]*1)
xlabel('Income Rank')
ylabel('Friendship')
set(gca,'xtick',[1:10:101])
set(gca,'xticklabel',[1:10:101])
xlim([min(x)-xlim_offset max(x)+xlim_offset])

subplot(2,2,3:4)
hold on
box on
plot(sy(1,:),fy(1,:), 'ro',...
    'markersize',ring_markersize,'markerfacecolor','w')
plot(sy(2,:),fy(2,:),'b.-',sy(1,:),fy(1,:),'k-');
set(gca,'xtick',[0:2.5:10])
set(gca,'xticklabel',[0:25:100])

xlabel('Salary (thousands of dollars)')
ylabel('Friendship')

saveas(figure(10),'Fig_Salaries.tif')

%% 5.6.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(11)
hold on
x=[-10:.01:10];
a=.5;
y=exp(-a*abs(x));
plot(x,y,'k-')
sample_x=[-10:10];
stdr=.06;  % want someting like .05
ms=5;
n_samples=8;
for sxi=1:size(sample_x,2)
    for nsi=1:n_samples
        sample_y(sxi,nsi)=exp(-a*abs(sample_x(sxi))) + stdr*randn;
    end
end
sample_y(sample_y>1)=1;  % id problem...
sample_y(sample_y<0)=0;  % id problem...
subplot(1,2,1)
plot(sample_x,sample_y,'o',...
    'markerfacecolor',[1 .6 .6]*1,'markeredgecolor',[0 0 1]*1,'markersize',ms)
box on
grid on
xlabel('Difference From Standard')
ylabel('Judged Similarity')
ylim([-.1 1.1])
set(gca,'ytick',[0:.2:1])

subplot(1,2,2)
hold on
for i=1:size(sample_x,2)
    errorbar(sample_x(i),mean(sample_y(i,:)),std(sample_y(i,:)),'k-')
end

% Fit exponential
a=[0:.01:1];
ssq=0;
best_ssq=inf;
for ai=1:size(a,2)
    for i=1:size(sample_y,1) % the rows corresponding to different differences from standard
        for j=1:size(sample_y,2) % the columns corresponding to different observations
            term_1=exp(-a(ai)*abs(sample_x(i)));
            term_2=sample_y(i,j);
            ssq=ssq+(term_1-term_2)^2;
        end
    end
    if ssq<best_ssq
        best_ssq=ssq;
        best_ai=ai;
    end
end
a(best_ai)
best_ai
best_ssq
raw_ssq=sum(sum(sample_y - mean(sample_y).^2))
r_square = 1-(best_ssq/raw_ssq)
best_y=exp(-a(best_ai)*abs(x));
plot(x,best_y,'k-')
plot(sample_x,mean(sample_y'),...
    'o','markerfacecolor',[1 .6 .6]*1,'markeredgecolor',[0 0 1]*1,'markersize',ms)
box on
grid on
xlabel('Difference From Standard')
ylabel('Judged Similarity')
ylim([-.1 1.1])
set(gca,'ytick',[0:.2:1])
text_object=text(0,0,[' a = -.',...
    num2str(100*a(best_ai)), newline, 'R^2 = .',num2str(100*r_square,2)],...
    'horizontalalignment','center','fontangle','ital','edgecolor','k')
get(text_object)
shg

%% 5.6.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(12)
hold on
x=[-10:.01:10];
a=.5;
y=exp(-a*abs(x));
plot(x,y,'k-')
sample_x=[-10:10];
stdr=.06;  % want someting like .05
ms=5;
n_samples=8;
for sxi=1:size(sample_x,2)
    for nsi=1:n_samples
        sample_y(sxi,nsi)=exp(-a*abs(sample_x(sxi))) + stdr*randn;
    end
end
sample_y(sample_y>1)=1;  % id problem...
sample_y(sample_y<0)=0; % id problem...
subplot(1,2,1)
plot(sample_x,sample_y,'o',...
    'markerfacecolor',[1 .6 .6]*1,'markeredgecolor',[0 0 1]*1,'markersize',ms)
box on
grid on
xlabel('Difference From Standard')
ylabel('Judged Similarity')
ylim([-.1 1.1])
set(gca,'ytick',[0:.2:1])

subplot(1,2,2)
hold on
for i=1:size(sample_x,2)
    errorbar(sample_x(i),mean(sample_y(i,:)),std(sample_y(i,:)),'k-')
end

% Fit exponential
a=[0:.01:1];
best_ssq=inf;
for ai=1:size(a,2)
    ssq=0;
    for i=1:size(sample_y,1) % the rows corresponding to different differences from standard
        for j=1:size(sample_y,2) % the columns corresponding to different observations
            term_1=exp(-a(ai)*abs(sample_x(i)));
            term_2=sample_y(i,j);
            ssq=ssq+(term_1-term_2)^2;
        end
    end
    if ssq<best_ssq
        best_ssq=ssq;
        best_ai=ai;
    end
end
a(best_ai)
best_ai
best_ssq
raw_ssq=sum(sum(sample_y - mean(sample_y).^2))
r_square = 1-(best_ssq/raw_ssq)
best_y=exp(-a(best_ai)*abs(x));
plot(x,best_y,'k-')
plot(sample_x,mean(sample_y'),'o',...
    'markerfacecolor',[1 .6 .6]*1,'markeredgecolor',[0 0 1]*1,...
    'markersize',ms)
box on
grid on
xlabel('Difference From Standard')
ylabel('Judged Similarity')
ylim([-.1 1.1])
set(gca,'ytick',[0:.2:1])
text_object=text(0,0,[' a = -.',...
    num2str(100*a(best_ai)), newline, 'R^2 = .',num2str(100*r_square,2)],...
    'horizontalalignment','center','fontangle','ital','edgecolor','k')
get(text_object)
shg

%% 5.7.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(13)
x=[0:-.02:1];

% Exponential
y=exp(-2*x);
subplot(2,2,1)
plot(x,y,'ro-')
title('Exponential','fontweight','normal')
xlabel('x')
ylabel('y')
grid on

subplot(2,2,3)
plot(log(x),log(y),'ro-')
xlabel('log(x)')
ylabel('log(y)')
grid on

% Power
y=x.^-2;
subplot(2,2,2)
plot(x,y,'bo-')
title('Power','fontweight','normal')
xlabel('x')
ylabel('y')
grid on

subplot(2,2,4)
plot(log(x),log(y),'bo-')
xlabel('log(x)')
ylabel('log(y)')
grid on

%% 5.7.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(14)
x=[0:.02:1];

% Exponential
y=exp(-2*x);
subplot(2,2,1)
plot(x,y,'ro-')
title('Exponential','fontweight','normal')
xlabel('x')
ylabel('y')
grid on

subplot(2,2,3)
plot(log(x),log(y),'ro-')
xlabel('log(x)')
ylabel('log(y)')
grid on

% Power
y=x.^-2;
subplot(2,2,2)
plot(x,y,'bo-')
title('Power','fontweight','normal')
xlabel('x')
ylabel('y')
grid on

subplot(2,2,4)
plot(log(x),log(y),'bo-')
xlabel('log(x)')
ylabel('log(y)')
grid on

%% 5.8.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(15)
n=10000;
n_bins=11;
mean=[-1 1];
standard_deviation=[.01 .5];
subplot_number=0;

% color combinations for the 4 bars. Each row is for a subplot. Each column
% is the proportion of red (column 1), green (column 2), and blue (column 3)
cmp=[
    .75 .50 .25;
    .50 .25 .75
    .25 .75 .50;
    .99 .50 .50];
xp=.67;
yp=.82;
fs=7;

for si=1:size(standard_deviation,2)  % I put this above the mean loop so the small means would be on the left
    for mi=1:size(mean,2)
        clear R
        R=mean(mi) + standard_deviation(si).*randn(1,n);
        range(R)
        subplot_number=subplot_number+1;
        subplot(size(mean,2),size(standard_deviation,2),subplot_number)
        hist(R,n_bins)
        set(get(gca,'child'),'FaceColor',cmp(subplot_number,1:3));
        xlim_array=xlim;
        ylim_array=ylim;
        
        text(xlim_array(1)+xp*(xlim_array(2)-xlim_array(1)),...
            ylim_array(1)+yp*(ylim_array(2)-ylim_array(1)),...
            ['mean = ' (mean(mi)), newline, ...
            'std = ' (standard_deviation(mi)), newline, ...
            'range = ' (range(R))],'fontsize',fs,'edgecolor','k');
        
    end
end

%% 5.8.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(16)
n=10000;
n_bins=11;
mean=[-1 1];
standard_deviation=[.01 .5];
subplot_number=0;

% color combinations for the 4 bars. Each row is for a subplot. Each column
% is the proportion of red (column 1), green (column 2), and blue (column 3)
cmp=[
    .75 .50 .25;
    .50 .25 .75
    .25 .75 .50;
    .99 .50 .50];
xp=.67;
yp=.82;
fs=7;
for si=1:size(standard_deviation,2)
    for mi=1:size(mean,2)
        clear R
        R=mean(mi) + standard_deviation(si).*randn(1,n);
        range(R)
        subplot_number=subplot_number+1;
        subplot(size(mean,2),size(standard_deviation,2),subplot_number)
        hist(R,n_bins)
        set(get(gca,'child'),'FaceColor',cmp(subplot_number,1:3));
        xlim_array=xlim;
        ylim_array=ylim;
        
        text(xlim_array(1)+xp*(xlim_array(2)-xlim_array(1)),...
            ylim_array(1)+yp*(ylim_array(2)-ylim_array(1)),...
            ['mean = ' num2str(mean(mi)), newline, ...
            'std = ' num2str(standard_deviation(si)), newline, ...
            'range = ' num2str(range(R),2)],'fontsize',fs,'edgecolor','k');
    end
end

%% 5.9.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(17)
n=8;
bar_shift=.1;
bar_width=.2;
rp=randperm(n)';
data= [rp n+1-rp]
sorted_data=sortrows(data,1);
hold on
bh_1=bar([1:n]-bar_shift,sorted_data(:,1),...
    'barwidth',bar_width,'displayname','Questionnaire 1')
set(bh_1,'FaceColor',[1 1 1]*.9);
bh_2=bar([1:n]+bar_shift,sorted_data(:,2),...
    'barwidth',bar_width,'displayname','Questionnaire 2');
set(bh_2,'FaceColor',[1 1 1]*.6);
set(gca,'xtick',[1:8])
set(gca,'xticklabel',['A','B','C','D','E','F','G','H'])
legend('show','location','north')
xlabel('Item')
ylabel('Number of Agreements')

%% 5.9.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(18)
n=8;
bar_shift=.1;
bar_width=.2;
rp=randperm(n)';
data= [rp n+1-rp]
sorted_data=sortrows(data,1);
hold on
bh_1=bar([1:n]-bar_shift,sorted_data(:,1),...
    'barwidth',bar_width,'displayname','Questionnaire 1')
set(bh_1,'FaceColor',[1 1 1]*.9)
bh_2=bar([1:n]+bar_shift,sorted_data(:,2),...
    'barwidth',bar_width,'displayname','Questionnaire 2');
set(bh_2,'FaceColor',[1 1 1]*.6)
set(gca,'xtick',[1:8])
set(gca,'xticklabel',['A';'B';'C';'D';'E';'F';'G';'H'])
legend('show','location','north')
xlabel('Item')
ylabel('Number of Agreements')

%% 5.10.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

figure(19)
ms=8; % markersize
hold on
stim=[-6:6];
n_stim=size(stim,2);
n_observations=500;
sdev=3;
for si=1:n_stim
    n_yeses(si)=0;
    for oi=1:n_observations
        if stim(si)+sdev*randn<stim(si)
            n_yeses(si)=n_yeses(si)+1;
        end
    end
end
n_yeses=n_yeses./n_observations;
bar(stim,n_yeses)
colormap([1 1 1]*.8)
for si=1:n_stim
    se_binomial=((n_yeses(si)*(1-n_yeses(si)))/n_observations).^.5;
    errorbar(stim(si),n_yeses(si),se_binomial,'k.-','markersize',ms)
end
xlim([min(stim)-1 max(stim)+1])
xLim=xlim;
ylim([0 1.05])
plot([xLim(1) xLim(2)],[.5 .5],'k--') % dashed line at chance
xlabel('Difference From Standard')
ylabel('p(''Yes'')')  % this is how to display quote marks
box on

%% 5.10.5 Solved Problem Code
clear all
close all
commandwindow
clc

figure(20)
ms=8; % markersize
hold on
stim=[-6:6];
n_stim=size(stim,2);
n_observations=500;
sdev=3;
for si=1:n_stim
    n_yeses(si)=0;
    for oi=1:n_observations
        if sdev*randn<stim(si)
            n_yeses(si)=n_yeses(si)+1;
        end
    end
end
n_yeses=n_yeses./n_observations;
bar(stim,n_yeses)
colormap([1 1 1]*.8)
for si=1:n_stim
    se_binomial=((n_yeses(si)*(1-n_yeses(si)))/n_observations).^.5;
    errorbar(stim(si),n_yeses(si),se_binomial,'k-','markersize',ms)
end
xlim([min(stim)-1 max(stim)+1])
xLim=xlim;
ylim([0 1.05])
plot([xLim(1) xLim(2)],[.5 .5],'k--') % dashed line at chance
xlabel('Difference From Standard')
ylabel('p(''Yes'')')  % this is how to display quote marks
box on
