%% MATLAB_BLUES_Chapter_6_Code_v6011.m

%% 6.1.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
min_diff_thusfar=100;
exceptional_score=9;
scores=mu + randn(n_students,1)*sigma;
scores(:,2)=abs(scores - mean(scores));
for k = 1:length(scores)
    difference = abs(scores(k) - mean(scores));
    if difference <  min_diff_thusfar
        min_diff_thusfar = difference;
        most_typical_student = k;
    end
end
most_typical_student
criterion=scores(most_typical_student)
for si=1:n_students
    if scores(si,1)<criterion
        training_method=1;
    else
        training_method=2;
    end
    scores_plus(si,:)=[scores(si,1:2) training_method];
end
% add 0 for unexceptional score or 1 for exceptional score to column 4
for si=1:n_students 
    if scores(si,2)<exceptional_score
        outlier=0;
    else
        outlier=1;
    end
    scores_plus(si,4)=outlier;
end
sorted_scores_plus=sortrows(scores_plus,3);
scores_plus_plus=[[1:size(scores_plus,1)]' sorted_scores_plus]

xlswrite(scores_plus_plus,'Student_Scores.xls')

%% 6.1.5 Solved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
min_diff_thusfar=100;
exceptional_score=9;
scores=mu + randn(n_students,1)*sigma;
scores(:,2)=abs(scores - mean(scores));

for k = 1:length(scores)
    difference = abs(scores(k) - mean(scores));
    if difference <  min_diff_thusfar
        min_diff_thusfar = difference;
        most_typical_student = k;
    end
end
most_typical_student
criterion=scores(most_typical_student)
for si=1:n_students
    if scores(si,1)<criterion
        training_method=1;
    else
        training_method=2;
    end
    scores_plus(si,:)=[scores(si,1:2) training_method];
end
% add 0 for unexceptional score or 1 for exceptional score to column 4
for si=1:n_students 
    if scores(si,2)<exceptional_score
        outlier=0;
    else
        outlier=1;
    end
    scores_plus(si,4)=outlier;
end
sorted_scores_plus=sortrows(scores_plus,3);
scores_plus_plus=[[1:size(scores_plus,1)]' sorted_scores_plus]

xlswrite('Student_Scores.xls',scores_plus_plus)

%% 6.2.2 Unsolved and Solved Problem Code
clear all
close all
commandwindow
clc

mu=80;
sigma=5;
n_students=20;
min_diff_thusfar=100;
scores=mu + randn(n_students,1)*sigma;
scores(:,2)=abs(scores - mean(scores));
for k = 1:length(scores)
    difference = abs(scores(k) - mean(scores));
    if difference <  min_diff_thusfar
        min_diff_thusfar = difference;
        most_typical_student = k;
    end
end
most_typical_student
criterion=scores(most_typical_student)
for si=1:n_students
    if scores(si,1)<criterion
        training_method=1;
    else
        training_method=2;
    end
    scores_plus(si,:)=[scores(si,1:2) training_method];
end
for si=1:n_students %creates outlier column tracking if absdifference > 9
    if scores(si,2)<9
        outlier=0;
    else
        outlier=1;
    end
    scores_plus(si,4)=outlier;
end
sorted_scores_plus=sortrows(scores_plus,3);
scores_plus_plus=[[1:size(scores_plus,1)]' sorted_scores_plus]
scores_plus_plus_table = ...
    array2table(scores_plus_plus,...
    'VariableNames',{'student','score',...
    'abs_difference','training_group','outlier'})
xlswrite('David_Table_Without_Col_Heads.xlsx',scores_plus_plus)

% Include row names and column names in another excel spreadsheet
% Bad code (commented)
col_header=['student','scores','abs_difference','training_group','outlier'];
% Good code (uncommented)
% col_header={'student','scores','abs_difference','training_group','outlier'};
xlswrite('David_Table_With_Col_Heads.xls',...
    col_header,'Sheet1','A1');  %Write column header
xlswrite('David_Table_With_Col_Heads.xls',...
    scores_plus_plus,'Sheet1','A2'); %Write data

%% 6.3.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

S=[1 2 3 4]
dlmwrite('Data_For_dlm_Check',S)
old_S=S;
dlmread('Data_For_dlm_Check')
new_S=S;
equality_of_old_S_and_new_S=isequal(old_S,new_S)

%% 6.3.5 Solved Problem Code
clear all
close all
commandwindow
clc

S=[1 2 3 4]
dlmwrite('Data_For_dlm_Check',S)
old_S=S;
new_S=dlmread('Data_For_dlm_Check')
equality_of_old_S_and_new_S=isequal(old_S,new_S)

%% 6.4.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

for run_through=1:2
    % generate fictional data for this subject whose filename number is uncertain
    n_data=20;
    clear data
    RT=1000+randn(n_data,1)*50;
    Heart_Rate=80+randn(n_data,1)*10;
    data=[RT Heart_Rate]
    
    % now assign a fresh subject number to this subject
    possible_si=0;
    new_subject=false;
    while new_subject==false
        possible_si=possible_si+1;
        if ~exist(['data_for_subject',num2str(possible_si),'.csv'])
            si=possible_si
            new_subject=true;
            subject_col(1:n_data,1)=si;
            data=[subject_col data];
            csvwrite(['data_for_subject_',num2str(si),'.csv'],data)
        end
    end
end % for run_through=1:2

%% 6.4.5 Solved Problem Code
clear all
close all
commandwindow
clc

for run_through=1:2
    % generate fictional data for this subject whose filename number is not yet certain
    n_data=20;
    clear data
    RT=1000+randn(n_data,1)*50;
    Heart_Rate=80+randn(n_data,1)*10;
    data=[RT Heart_Rate]
    
    % now assign a fresh subject number to this subject
    possible_si=0;
    new_subject=false;
    while new_subject==false
        possible_si=possible_si+1;
        if ~exist(['data_for_subject_',num2str(possible_si),'.csv'])
            si=possible_si
            new_subject=true;
            subject_col(1:n_data,1)=si;
            data=[subject_col data];
            csvwrite(['data_for_subject_',num2str(si),'.csv'],data)
        end
    end
end % for run_through=1:2

%% 6.5.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_subjects=20;
clear data
for si=1:n_subjects
    subject_id=-inf;
    while (subject_id<1000) | (subject_id>9999)
        subject_id=randi(10000);
    end
    RT=1000+randn*50;
    Heart_Rate=80+randn*10;
    data(si,1:4)=[si subject_id RT Heart_Rate];
end
disp('Unformatted data')
data
disp('')

disp('Formatted data')
fprintf('\n');
for row=1:size(data,1)
    fprintf('%4d',data(row,1));
    fprintf('%12d',data(row,2));
    fprintf('%12.2f',data(row,3:4));   
end

% save formatted data to a text file after first opening (creating) the
% file with fopen and being sure to close the file after data have been written to
% it with fclose
fid = fopen('david_week_5_formatted_data.txt','wt');
for row=1:size(data,1)
    fprintf(fid,'%4d',data(row,1));
    fprintf(fid,'%12d',data(row,2));
    fprintf(fid, '%12.2f',data(row,3:4));
    fprintf(fid,'\n');
end
fclose(fid);

%% 6.5.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_subjects=20;
clear data
for si=1:n_subjects
    subject_id=-inf;
    while (subject_id<1000) | (subject_id>9999)
        subject_id=randi(10000);
    end
    RT=1000+randn*50;
    Heart_Rate=80+randn*10;
    data(si,1:4)=[si subject_id RT Heart_Rate];
end
disp('Unformatted data')
data
disp('')

disp('Formatted data')
fprintf('\n');
for row=1:size(data,1)
    fprintf('%4d',data(row,1));
    fprintf('%12d',data(row,2));
    fprintf('%12.2f',data(row,3:4));
    fprintf('\n');
end

% save formatted data to a text file after first opening (creating) and
% being sure to close the file after data have been written to it
fid = fopen('david_week_5_formatted_data.txt','wt');
for row=1:size(data,1)
    fprintf(fid,'%4d',data(row,1));
    fprintf(fid,'%12d',data(row,2));
    fprintf(fid, '%12.2f',data(row,3:4));
    % Good code added
    fprintf('\n');  % insert a line return
    
end
fclose(fid);

%% 6.6.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_students=20;
max_grade=100;

score(1:n_students,1:2)=[[1:n_students]' randi(max_grade,n_students,1)]
disp(' ')
fid_xls=fopen('Grades.xls','w'); 
fprintf('%s \t %s \n', 'Student_ID', 'Letter_Grade');
fprintf(fid_xls,'%s \t %s \n', 'Student_ID', 'Letter_Grade');

for i=1:size(score,1)
%     letter='F'; % GREAT !!!!!!!!
    
    if score(i,2) >= 64
        letter='D-';
    end
    if score(i,2) >= 67
        letter='D';
    end
    if score(i,2) >= 70
        letter='D+';
    end
    if score(i,2) >= 73
       letter='C-';
    end
    if score(i,2) >= 76
        letter='C';
    end
    if score(i,2) >= 79
        letter='C+';
    end
    if score(i,2) >= 82
       letter='B-';
    end
    if score(i,2) >= 85
       letter='B';
    end
    if score(i,2) >= 88
        letter='B+';
    end
    if score(i,2) >= 91
        letter='A-';
    end
    if score(i,2) >= 94
        letter='A';
    end
    if score(i,2) >= 97
        letter='A+';
    end
     
    fprintf('%d \t %s \n', score(i,1), letter)
    fprintf(fid_xls,'%d \t %s \n', score(i,1),letter);
       
end   
fclose(fid_xls);

%% 6.6.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_students=20;
max_grade=100;

score(1:n_students,1:2)=[[1:n_students]' randi(max_grade,n_students,1)]
disp(' ')
fid_xls=fopen('Grades.xls','w'); 
fprintf('%s \t %s \n', 'Student_ID', 'Letter_Grade');
fprintf(fid_xls,'%s \t %s \n', 'Student_ID', 'Letter_Grade');

for i=1:size(score,1)
    letter='F';
    
    if score(i,2) >= 64
        letter='D-';
    end
    if score(i,2) >= 67
        letter='D';
    end
    if score(i,2) >= 70
        letter='D+';
    end
    if score(i,2) >= 73
       letter='C-';
    end
    if score(i,2) >= 76
        letter='C';
    end
    if score(i,2) >= 79
        letter='C+';
    end
    if score(i,2) >= 82
       letter='B-';
    end
    if score(i,2) >= 85
       letter='B';
    end
    if score(i,2) >= 88
        letter='B+';
    end
    if score(i,2) >= 91
        letter='A-';
    end
    if score(i,2) >= 94
        letter='A';
    end
    if score(i,2) >= 97
        letter='A+';
    end
     
    fprintf('%d \t %s \n', score(i,1), letter)
    fprintf(fid_xls,'%d \t %s \n', score(i,1),letter);
       
end   
fclose(fid_xls);

%% 6.7.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

name = input('What is your name? ', 's');
sprintf('Hello, %s, I will try to help you.', name)

%% 6.7.5 Solved Problem Code
clear all
close all
commandwindow
clc

name_gotten=false;
while name_gotten==false
    name = input('What is your name? ', 's');
    if ~isempty(name)
        sprintf('Hello, %s, I will try to help you.', name)
        name_gotten=true;
    else
        sprintf('Oops, be sure to type something, and not just hit the Enter key.')
    end
end

%% 6.8.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

% list numerical equivalents of the lower-case letters from 'a' through 'z'
double(['a' 'z'])
% list numerical equivalents of the upper-case letters from 'A' through 'Z'
double(['A' 'Z'])
lower_case_letter_doubles=double(char([97:122]))
upper_case_letter_doubles=double(char([65:90]))
both_case_letter_doubles=[lower_case_letter_doubles upper_case_letter_doubles];

% initiate and carry out the conversation
conversation_OK=false; % initialized to false but can become true
need_to_scold=false; % initialized to false but can become true
while conversation_OK==false
    clc
    if need_to_scold==true
        disp(['Sorry but that''s not in my lexicon.'])
    end
    name = input(['What is your name?\n' ...
        'Please don''t put in characters other than letters or you''ll confuse me! '], 's');
    
    if ~isempty(name)  % Don't accept Enter key alone       
        % Check if name is letters.
        OK_string=true;
        for i=1:length(name)
            OK_letter(i)=false;
            for j=1:length(both_case_letter_doubles)
                if double(name(i))==both_case_letter_doubles(j) 
                    OK_letter(i)=true;
                end
            end
            if OK_letter(i)==false
                OK_string=false;
                break
            end
        end
        if OK_string==true
            conversation_OK=true;           
            sprintf('Hello, %d, I will try to help you now.', name)           
        else
            need_to_scold=true;
        end     
    end % while conversation_OK==false
end

%% 6.8.5 Solved Problem Code
clear all
close all
commandwindow
clc

% list numerical equivalents of the lower-case letters from 'a' through 'z'
double(['a' 'z'])
% list numerical equivalents of the upper-case letters from 'A' through 'Z'
double(['A' 'Z'])
lower_case_letter_doubles=double(char([97:122]))
upper_case_letter_doubles=double(char([65:90]))
both_case_letter_doubles=[lower_case_letter_doubles upper_case_letter_doubles];

% initiate and carry out the conversation
conversation_OK=false; % initialized to false but can become true
need_to_scold=false; % initialized to false but can become true
while conversation_OK==false
    clc
    if need_to_scold==true
        disp(['Sorry but that''s not in my lexicon.'])
    end
    name = input(['What is your name?\n' ...
        'Please don''t put in characters other than letters or you''ll confuse me! '], 's');
    
    if ~isempty(name)  % Don't accept Enter key alone      
        % Check if name is letters.
        OK_string=true;
        for i=1:length(name)
            OK_letter(i)=false;
            for j=1:length(both_case_letter_doubles)
                if double(name(i))==both_case_letter_doubles(j)  % good bloop! I left out double(
                    OK_letter(i)=true;
                end
            end
            if OK_letter(i)==false
                OK_string=false;
                break
            end
        end
        if OK_string==true
            conversation_OK=true;           
            % BAD CODE
            % sprintf('Hello, %d, I will try to help you now.', name)
            % GOOD CODE
            sprintf('Hello, %s, I will try to help you now.', name)
        else
            need_to_scold=true;
        end        
    end % while conversation_OK==false
end

%% 6.9.2 Unsolved Problem Code
clear all
close all
commandwindow
clc
emails_match=false;
while emails_match == false
    characters_bad=true;
    while characters_bad==true
        email=...
            input(...
            ['Please enter your email. Make sure it has an @ sign. '],...
            's');
        if ~contains(email,'@')
            disp(['Oops, I''m' ' not seeing a @'])
        end
    end % while characters_bad==true
    clc
    
    characters_bad=true;
    while characters_bad==true
        email_2=...
            input(...
            ['Please confirm your email by re-entering it.'...
            'Again make sure it has an @ sign. '],'s');
        if ~contains(email,'@')
            disp(['Oops, I''m' ' not seeing a @'])
        end
    end % while characters_bad==true
    clc
    if email == email_2
        disp (['Thank you, your email has been entered.']);
        emails_match=true;
    else
        disp(['Your confirmation did not match.'...
            'Please enter your email address again.']);
    end
end

%% 6.9.5 Solved Problem Code
clear all
close all
commandwindow
clc

emails_match=false;
while emails_match == false
    characters_bad=true;
    while characters_bad==true
        email=input ([...
            'Please enter your email. Make sure it has an @ sign. '],'s');
        if ~contains(email,'@')
            disp(['Oops, I''m' ' not seeing a @'])
        else characters_bad=false;  % leave out for error!!!
        end
    end % while characters_bad==true
    clc
    
    characters_bad=true;
    while characters_bad==true
        email_2=input(...
            ['Please confirm your email by re-entering it.'...
            'Again make sure it has an @ sign. '],'s');
        if ~contains(email_2,'@')
            disp(['Oops, I''m' ' not seeing a @'])
        else characters_bad=false;  % leave out for error!!!
        end
    end % while characters_bad==true
    clc
    if email == email_2
        disp (['Thank you, your email has been entered.']);
        emails_match=true;
    else
        disp (['Your confirmation did not match.'...
            'Please enter your email address again.']);
    end
end

%% 6.10.2 Solved Problem Code (No Unsolved Problem Code)
clear all
close all
commandwindow
clc

n_stim=8; % number of stimuli arrayed around an imaginary circle
max_angle=((n_stim-1)/n_stim)*(2*pi); % the largest angle out from the center of the imaginary circle where the stim with the largest number appears
stim_angle=linspace(0,max_angle,n_stim); % the possible angles out from the center of the imaginary circle
stim_dist=1; % distance of each dot from the center
x_center=0; % the x value of the center
y_center=0; % the y value of the center
ms=14;  % markersize
stim_radius=.15; % the default radius of each dot

fill_angles=linspace(0,2*pi,360); % angles needed to fill each dot with a [red green blue] combination
n_trials=4;  % number of trials

min_scp = .5; % minimum size change proportion of the target stim relative to distractors
max_scp = 1.5; % minimum size change proportion of the target stim relative to distractors

data=[];  % intialize data
for trial=1:n_trials
    odd_stim=randperm(n_stim,1);  % which stim will be the odd one
    scp = min_scp+rand*(max_scp - min_scp);
    
    % set figure number and fill the screen with the figure.
    % the values for 'OuterPosition' were gotten by clicking on the
    % "blowup" icon when the figure was shown to make it as big as
    % possible, and then the author used get(gcf) to find the position values.
    set(figure(trial),...
        'units','normalized', 'OuterPosition',[-0.005 0.10389 1.01 0.905])
    hold on
    axis square
    axis off
    xlim([-stim_dist-1 stim_dist+1])
    ylim([-stim_dist-1 stim_dist+1])
    xL=xlim;  % need this for filling the screen; can't use xlim directly
    yL=ylim;  % need this for filling the screen; can't use ylim directly
    for si=1:n_stim
        if si==odd_stim
            temp_stim_radius=stim_radius*scp;
        else
            temp_stim_radius=stim_radius;
        end
        acceptable_distance(si)=temp_stim_radius;
        fill...
            (x_center+stim_dist*cos(stim_angle(si))+...
            temp_stim_radius*cos(fill_angles),...
            y_center+stim_dist*sin(stim_angle(si))+...
            temp_stim_radius*sin(fill_angles),...
            [1 1 1]*.5);
    end %for si=1:n_stim
    
    % collect response click
    a_target_has_been_clicked=false;
    while a_target_has_been_clicked==false
        [x_click y_click]=ginput(1);  % have user click on target showing crosshairs
        for si=1:n_stim
            
            if (abs(x_click-(x_center+stim_dist*cos(stim_angle(si)))) < ...
                    acceptable_distance(si)) && ...
                    (abs(y_click-(y_center+stim_dist*sin(stim_angle(si)))) < ...
                    acceptable_distance(si))
                
                a_target_has_been_clicked=true;
                clicked_stim=si;
                if clicked_stim == odd_stim
                    text(x_center,y_center,...
                        'Correct','horizontalalignment','center')
                    accuracy=1;
                else
                    text(x_center,y_center,...
                        'Incorrect','horizontalalignment','center')
                    accuracy=0;
                end
                data=[data; ...
                    trial si clicked_stim odd_stim scp ...
                    accuracy x_click  x_center+stim_dist*cos(stim_angle(si)) ...
                    y_click  y_center+stim_dist*sin(stim_angle(si)) ...
                    ]
                break
                
            end
        end % for si=1:n_stim
    end %  while a_target_has_been_clicked==false
    plot(x_click,y_click,'k+','markersize',40)
    saveas(gcf,['figure_',num2str(trial),'.tif'])
    pause(1)  % pause for 1 second
    % clear the figure window; then have it fill computer screen again
    set(figure(trial),'units','normalized', ...
        'OuterPosition',[-0.005 0.10389 1.01 0.905])
    
end %  for trial=1:n_trials
data

% end of block feedback
set(figure(trial+1),'units','normalized',...
    'OuterPosition',[-0.005 0.10389 1.01 0.905])
hold on
axis square
axis off
xlim([-stim_dist-1 stim_dist+1])
ylim([-stim_dist-1 stim_dist+1])
xL=xlim;  % need this for filling screen
yL=ylim;  % need this for filling screen
text(x_center,y_center,['Total correct trials out of ' ...
    num2str(n_trials) ' =  ' num2str(sum(data(:,5))),...
    newline,'Hit enter when done'], ...
    'horizontalalignment','center')
saveas(gcf,['end_of_block,.tif'])


