%% MATLAB_BLUES_Chapter_8_Code_v8005.m

%% 8.1.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

M(1:10,1:2)=rand
disp(' ')
disp('Size, Rows, Columns')
size(M)
size(M,1)
size(M,2)
disp(' ')
disp('Number of elements via numel and product')
numel(M)
prod(size(M,1),size(M,2))
disp(' ')
disp('Length and larger of the two size elements')
length(M)
max(size(M))
disp('Smaller of the two size elements')
min(size(M))

%% 8.1.5 Solved Problem Code
clear all
close all
commandwindow
clc

M(1:10,1:2)=rand
disp(' ')
disp('Size, Rows,Columns')
size(M)
size(M,1)
size(M,2)
disp(' ')
disp('Number of elements via numel, multiplication, and times rather than prod.')
numel(M)
% prod(size(M,1),size(M,2)) % now commented out
size(M,1)*size(M,2)
times(size(M,1),size(M,2))
disp(' ')
disp('Length and larger of the two size elements')
length(M)
max(size(M))
disp('Smaller of the two size elements')
min(size(M))

%% 8.2.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

max_rows=4;
max_cols=4;
j=0;
summary=[];
for n_rows=2:2:max_rows
    for n_rows=2:2:max_rows
        for n_cols=2:2:max_cols
            X(1:n_rows,1:n_cols)=n_rows+n_cols;
        end
    end
end

% Set the last value in the matrix to NaN
X(n_rows,n_cols)=NaN
disp(' ')
disp('Means of each column without any special argument')
[mean(mean(X,1)) mean(mean(X,2))]
disp(' ')
disp('Means of each column using nanmean')
[nanmean(nanmean(X,1)) nanmean(nanmean(X,2))]
disp('Means of each column with omitnan')
[mean(mean(X,1),'omitnan') mean(mean(X,2),'includenan')]

%% 8.2.5 Solved Problem Code
clear all
close all
commandwindow
clc

max_rows=4;
max_cols=4;
j=0;
summary=[];
for n_rows=2:2:max_rows
    for n_rows=2:2:max_rows
        for n_cols=2:2:max_cols
            X(1:n_rows,1:n_cols)=n_rows+n_cols;
        end
    end
end

% Set the last value in the matrix to NaN
X(n_rows,n_cols)=NaN
disp(' ')
disp('Means of each column without any special argument')
[mean(mean(X,1)) mean(mean(X,2))]
disp(' ')
disp('Means of each column using nanmean')
[nanmean(nanmean(X,1)) nanmean(nanmean(X,2))]
disp(' ')
disp('Means of each column with omitnan')
[mean(mean(X,1),'omitnan') mean(mean(X,2),'omitnan')]

%% 8.3.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_locations=8; % number of box locations
n_cycles=2;  % number of cycles in which the n_locations are shown
% value of n_cycles is the smallest value possible to pick up some learning
% and is low because the crosshairs make responding so tedious ... would
% like to be able to go much faster
box_marker_size=80; % size of the box
point_marker_size=8; % size of the points used to graph the resuls

% basic sequence of locations
x=[ 0  0 -1 -1  0  0  1  1];
y=[-1  1  1 -1 -1  1  1 -1];

% basic sequence replicated for the n_cycles
xc=[]; yc=[];
for c=1:n_cycles
    xc=[xc x];
    yc=[yc y];
end
xc;  % did not have semi-colon at first so it could be checked during development
yc;  % did not have semi-colon at first so it could be checked during development

figure(1)
j=0; % counter for events
for c=1:n_cycles
    for i=1:n_locations
        j=j+1;
        plot(xc(j),yc(j),'ks','markersize',box_marker_size)
        tic
        axis([-1 1 -1 1]*2);  % set limits of the graph
        axis off  % don't show the x or y axis
        [xg(j) yg(j)]=ginput(1);  % record the click location 1 time per event
        t(j)=toc; % record the time of the response
    end
end
close

figure(2)
plot(xg,yg,'k.-','markersize',point_marker_size)

figure(3)
hold on
plot(xg,'r.-','markersize',point_marker_size)
plot(yg,'b.-','markersize',point_marker_size)
legend('xg','yg','location','northwest')

% Plot the second through the last times. Omit the first time since it
% includes getting started (a different kind of event).
figure(4)
plot(t(2:end),'bo-')
xlabel('Response')
ylabel('Time (s)')

% Gather x values in the north box before heading west and east and do a t
% test on those two samples
x_before_heading_west=xg(2:8:end)
x_before_heading_east=xg(4:8:end)
[h,p] = ttest(x_before_heading_west,x_before_heading_east,'Alpha',0.05)

disp('Mean and std of x_before_heading_west and of x_before_heading_east')
[mean(x_before_heading_west) std(x_before_heading_west) ...
mean(x_before_heading_east) std(x_before_heading_east)]

%% 8.3.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_locations=8; % number of box locations
n_cycles=4;  % number of cycles in which the n_locations are shown
box_marker_size=80; % size of the box
point_marker_size=8; % size of the points used to graph the resuls

% basic sequence of locations
x=[ 0  0 -1 -1  0  0  1  1];
y=[-1  1  1 -1 -1  1  1 -1];

% basic sequence replicated for the n_cycles
xc=[];
yc=[];
for c=1:n_cycles
    xc=[xc x];
    yc=[yc y];
end
xc;  % did not have semi-colon at first so it could be checked
yc;  % did not have semi-colon at first so it could be checked

figure(1)
j=0; % counter for events
for c=1:n_cycles
    for i=1:n_locations
        j=j+1;
        plot(xc(j),yc(j),'ks','markersize',box_marker_size)
        tic
        axis([-1 1 -1 1]*2);  % set limits of the graph
        axis off  % don't show the x or y axis
        % [xg(j) yg(j)]=ginput(1); % record the click location once with crosshairs
        [xg(j) yg(j)]=david_ginput(1);  % record the click location once without crosshairs
        t(j)=toc; % record the time of the response
    end
end
close

figure(2)
plot(xg,yg,'k.-','markersize',point_marker_size)

figure(3)
hold on
plot(xg,'r.-','markersize',point_marker_size)
plot(yg,'b.-','markersize',point_marker_size)
legend('xg','yg','location','northwest')

% Plot the second through the last times. Omit first time since it includes getting
% started (a different kind of event).
figure(4)
plot(t(2:end),'bo-')
xlabel('Response')
ylabel('Time (s)')

% Gather x values in the north box before heading west and east and do a t
% test on those two samples
x_before_heading_west=xg(2:8:end)
x_before_heading_east=xg(4:8:end)
[h,p] = ttest(x_before_heading_west,x_before_heading_east,'Alpha',0.05)

disp('Mean and std of x_before_heading_west and of x_before_heading_east')
[mean(x_before_heading_west) std(x_before_heading_west) ...
mean(x_before_heading_east) std(x_before_heading_east)]

%% 8.4.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

[nums text raw]=xlsread('David_Week_7_Excel_Relationships_03.xlsx')
whos
fig_number=1;
set(gcf,'position',[1 41 1280 611.2]);
hold on
axis([0 1 0 1])
text_x_shift=.005;

for i=1:size(nums,1)
    plot(nums(i,1),nums(i,2),'.','markersize',18)
    text(nums(i,1)+text_x_shift,nums(i,2),num2str(text{i+1,4}),...,
        'horizontalalignment','left','fontsize',12)
end
plot([0 1],[0 1],'k-')
axis([0 1 0 1])
grid on
box on
xlabel('Sender''s Desire To Send')
ylabel('Receiver''s Desire to Receive')

%% 8.4.5 Solved Problem Code
clear all
close all
commandwindow
clc

[nums txt raw]=xlsread('David_Week_7_Excel_Relationships_03.xlsx')
whos
fig_number=1;
set(gcf,'position',[1 41 1280 611.]);
hold on
axis([0 1 0 1])
text_x_shift=.005;
for i=1:size(nums,1)
    plot(nums(i,1),nums(i,2),'.','markersize',18)
    text(nums(i,1)+text_x_shift,nums(i,2),num2str(txt{i+1,4}),...
        'horizontalalignment','left','fontsize',12)
end
plot([0 1],[0 1],'k-')
axis([0 1 0 1])
grid on
box on
xlabel('Sender''s Desire To Send')
ylabel('Receiver''s Desire to Receive')

%% 8.5.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

disp('Value before calling stop_typing_four_commands')
x=1

stop_typing_four_commands
disp('Value after calling stop_typing_four_commands. x should be undefined.')
x

%% 8.5.5 Solved Problem Code
clear all
close all
commandwindow
clc

disp('Value before calling david_housekeeping')
x=1

david_housekeeping
disp('Value after calling david_housekeeping. x should be undefined.')
x

%% 8.6.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

% Badly_formatted_function.m
[truth,how_many]=david_is_in_how_often_badly_formatted(candidates,full_set)
% number_of_input_arguments = nargin;  % just for interest's sake
% number_of_output_arguments = nargout; % just for interest's sake
% 
% how_many(1:size(candidates,1),1:size(candidates,2))=0;
% for ca=1:size(candidates,1) % for all the rows of candidates
%     for ra=1:size(candidates,2) % for all the columns per row of candidates
%         for cf=1:size(full_set,1) % for all the rows of full_set
%             for rf=1:size(full_set,2)  % for all the coluns of full_set
%                 if candidates(ca,ra)==full_set(cf,rf)
%                     how_many(ca,ra)=how_many(ca,ra)+1;
%                 end
%             end
%         end
%     end
% end
% if sum(sum(how_many))==0
%     truth=0;
% else
%     truth=1;
% end

% Illustrative call:
% candidates=[2 3; 4 5;17 18]
% full_set=[1:2]
% Badly_formatted_function(candidates,full_set)

% Error Message
% Attempt to execute SCRIPT Badly_formatted_function as a function:
% C:\Users\David_A_Rosenbaum\Documents\Dumb Backup Begun 06-01-18\Badly_formatted_function.m 

%% 8.6.5 Solved Problem Code
clear all
close all
commandwindow
clc

% function [truth,how_many]=david_is_in_how_often(candidates,full_set)
% number_of_input_arguments = nargin;  % just for interest's sake
% number_of_output_arguments = nargout; % just for interest's sake
% 
% how_many(1:size(candidates,1),1:size(candidates,2))=0;
% for ca=1:size(candidates,1) % for all the rows of candidates
%     for ra=1:size(candidates,2) % for all the columns per row of candidates
%         for cf=1:size(full_set,1) % for all the rows of full_set
%             for rf=1:size(full_set,2)  % for all the coluns of full_set
%                 if candidates(ca,ra)==full_set(cf,rf)
%                     how_many(ca,ra)=how_many(ca,ra)+1;
%                 end
%             end
%         end
%     end
% end
% if sum(sum(how_many))==0
%     truth=0;
% else
%     truth=1;
% end

% Illustrative call:
candidates=[2 3; 4 5;17 18]
full_set=[1:2]
[truth,how_many]=david_is_in_how_often(candidates,full_set)

%% 8.7.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

% function ed = david_euclid_dist_any_D(M)
% % Find the Euclidean distance over points in any number of dimensions.
% % The columns of M are the dimensions (e.g., "x" for col 1, "y" for col 2,
% % etc), and the rows >=2 are the successive points.
% for row=1:size(M,1)
%     if row==1
%         ssq=0;
%     else
%         ssq=ssq+sum((M(row,:)- M(row-1,:)).^2);
%     end
% end
% ed = sqrt(ssq);
 

M=[0 1 2 1 2 3 2 3 4];
david_euclid_dist_any_D(M)

%% 8.7.5 Solved Problem Code
clear all
close all
commandwindow
clc

% function ed = david_euclid_dist_any_D(M)
% % Find the Euclidean distance over points in any number of dimensions.
% % The columns of M are the dimensions (e.g., "x" for col 1, "y" for col 2,
% % etc), and the rows >=2 are the successive points.
% for row=1:size(M,1)
%     if row==1
%         ssq=0;
%     else
%         ssq=ssq+sum((M(row,:)- M(row-1,:)).^2);
%     end
% end
% ed = sqrt(ssq);
 
M=[0 1 2; 1 2 3; 2 3 4];
david_euclid_dist_any_D(M)
pause
% function ed = david_euclid_dist_any_D_idiot_proofed(points_per_dimension, n_dimensions, M);
% % Find the Euclidean distance for one or more points_per_dimension in one
% % or more n_dimensions using the matrix of coordinate values whose columns
% % of are the dimensions (e.g., "x" for col 1, "y" for col 2, the first two
% % dimensions), and the rows are for the successively listed points.
% 
% ed=NaN;
% 
% if (points_per_dimension>1) & ...
%         (n_dimensions>=1) & ...
%         (size(M,1)==points_per_dimension) & ...
%         (size(M,2)==n_dimensions) & ...
%         (size(M,1)>=1)   
%     for row=1:size(M,1)
%         if row==1
%             ssq=0;
%         else
%             ssq=ssq+sum((M(row,:)- M(row-1,:)).^2);
%         end
%     end
%     ed = sqrt(ssq);
% else
%     disp('There is an error in your input to the function.')
%     disp(['The value of ed is NaN,'...
%         'which indicates that there is a problem in the way you called this function.'])
%     disp('Please try again. You might need semi-colons, for example.')
%     disp(' ')
%     return
% end
% Illustrative call for one points in 2D space:
% clear M; M=[0 0]; david_euclid_dist_any_D(M)

% Illustrative call for two points in 2D space:
% clear M; M=[0 0; 1 1]; david_euclid_dist_any_D(M)

% Illustrative call for three points in 3D space:
% clear M; d=3; M=[0 1 2; 1 2 3; 2 3 4];david_euclid_dist_any_D(M)

% points_per_dimension=3; n_dimensions=3; coordinates=[0 1 2; 1 2 3; 2 3 4];
%  ed = david_euclid_dist_any_D_idiot_proofed(points_per_dimension, n_dimensions,M)

% First call
points_per_dimension=3;
n_dimensions=3;
coordinates=[0 1 2; 1 2 3; 2 3 4];
ed = david_euclid_dist_any_D_idiot_proofed(points_per_dimension, n_dimensions, M)

% Second call
clear M
M=[0 1 2  1 2 3  2 3 4];
points_per_dimension=2; n_dimensions=3; coordinates=[0 1 2; 1 2 3; 2 3 4];
ed = david_euclid_dist_any_D_idiot_proofed(points_per_dimension, n_dimensions, M)

%% 8.8.2 Unsolved Problem Code
close all
clear all
commandwindow
clc

% function david_axis_labels_function(...
%     my_y_label_x, my_y_label_y, my_y_value, ...
%     my_x_label_x, my_x_label_y, my_x_value, ...
%     left_of_decimal, right_of_decimal)
%
% % function to control the number of digits to the right of the decimal
% % point when using the text command to produce xticklabels and yticklabels.
% % The function is called for one ticklabel at a time (for one tick mark at
% % The inputs to the function are the horizontal position of the ytick
% % (my_y_label_x), the vertical position of the ytick
% % (my_y_label_y), the number of digits to the left of the decimal point,
% % the actual yticklabel value, and then the corresponding values for
% % xticks.
% 
% text(my_y_label_x, my_y_label_y, sprintf(['%' num2str(left_of_decimal) '.' num2str(right_of_decimal) 'f'],my_y_value),...
%     'backgroundcolor','none','edgecolor','w','horizontalalignment','right')
% text(my_x_label_x, my_x_label_y,sprintf(['%2.' num2str(right_of_decimal) 'f'],my_x_value),...
%     'backgroundcolor','none','edgecolor','w','horizontalalignment','center')
% 
% return

n_ticks=5;
marker_size=9;
for sbp=1:2
    subplot(1,2,sbp)
    axis([0 1 0 1])

    plot([-.25:.25:.75],[-.25:.25:.75],'s-','markersize',marker_size,...
        'markerfacecolor','r','markeredgecolor','k')
    axis([-.5 1 -.5 1])
    hold on
    if sbp==1
        xs=[-.25:.25:.75];
        ys=[-.25:.25:.75];
        set(gca,'xtick',xs)
        set(gca,'ytick',ys)
    elseif sbp==2
        xs=[-.25:.25:.75];
        ys=[-.25:.25:.75];
        my_y_label_x(1:n_ticks)=-.54;
        my_x_label_x(1:n_ticks)=xs;
        my_x_label_y(1:n_ticks)=-.60;
        set(gca,'xtick',xs)
        set(gca,'ytick',ys)
        set(gca,'xticklabel',[])
        set(gca,'yticklabel',[])
        for i=1:n_ticks
            left_of_decimal=1;
            right_of_decimal=.2;
            david_axis_labels_function(my_y_label_x(i),ys(i),ys(i),...
                    xs(i),my_x_label_y(i),ys(i),left_of_decimal, right_of_decimal)
        end
    end
end

%% 8.8.5 Solved Problem Code
close all
clear all
commandwindow
clc

% function david_axis_labels_function(...
%     my_y_label_x, my_y_label_y, my_y_value, ...
%     my_x_label_x, my_x_label_y, my_x_value, ...
%     left_of_decimal, right_of_decimal)
%
% % function to control the number of digits to the right of the decimal
% % point when using the text command to produce xticklabels and yticklabels.
% % The function is called for one ticklabel at a time (for one tick mark at
% % The inputs to the function are the horizontal position of the ytick
% % (my_y_label_x), the vertical position of the ytick
% % (my_y_label_y), the number of digits to the left of the decimal point,
% % the actual yticklabel value, and then the corresponding values for
% % xticks.
% 
% text(my_y_label_x, my_y_label_y, sprintf(['%' num2str(left_of_decimal) '.' num2str(right_of_decimal) 'f'],my_y_value),...
%     'backgroundcolor','none','edgecolor','w','horizontalalignment','right')
% text(my_x_label_x, my_x_label_y,sprintf(['%2.' num2str(right_of_decimal) 'f'],my_x_value),...
%     'backgroundcolor','none','edgecolor','w','horizontalalignment','center')
% 
% return

close all
clear all
commandwindow
clc

rotation_angle_x=45;
rotation_angle_y=0;
n_ticks=5;
marker_size=9;
for sbp=1:2
    subplot(1,2,sbp)
    axis([0 1 0 1])

    plot([-.25:.25:.75],[-.25:.25:.75],'s-','markersize',marker_size,...
        'markerfacecolor','r','markeredgecolor','k')
    axis([-.5 1 -.5 1])
    hold on
    if sbp==1
        xs=[-.25:.25:.75];
        ys=[-.25:.25:.75];
        set(gca,'xtick',xs)
        set(gca,'ytick',ys)
    elseif sbp==2
        xs=[-.25:.25:.75];
        ys=[-.25:.25:.75];
        my_y_label_x(1:n_ticks)=-.54;
        my_x_label_x(1:n_ticks)=xs;
        my_x_label_y(1:n_ticks)=-.60;
        set(gca,'xtick',xs)
        set(gca,'ytick',ys)
        set(gca,'xticklabel',[])
        set(gca,'yticklabel',[])
        for i=1:n_ticks
            left_of_decimal=1;
            right_of_decimal=2;
            david_axis_labels_function_plus_rotations(my_y_label_x(i),...
                ys(i),ys(i),...
                xs(i),my_x_label_y(i),ys(i),...
                left_of_decimal, right_of_decimal,...
                rotation_angle_x, rotation_angle_y)
        end
    end
end

%% 8.9.2 Unsolved Problem Code
% function david_arrow(x_start,x_end,y_start,y_end,arrow_radius,arrow_radius_coef,...
%     arrow_angle,shaft_descriptor,n_angles_for_test)
% best_angle=david_angle_find_2(x_start,x_end,y_start,y_end,n_angles_for_test);
% hold on
% plot([x_start,x_end],[y_start,y_end],shaft_descriptor)
% fill([x_end,...
%     x_end+arrow_radius*cos(best_angle-arrow_angle),...
%     x_end+arrow_radius_coef*arrow_radius*cos(best_angle),...
%     x_end+arrow_radius*cos(best_angle+arrow_angle),x_end],...
%     [y_end,...
%     y_end+arrow_radius*sin(best_angle-arrow_angle),...
%     y_end+arrow_radius_coef*arrow_radius*sin(best_angle), ...
%     y_end+arrow_radius*sin(best_angle+arrow_angle),y_end],...
%     [.82 .82 .82]); %'k');
 

% function best_angle=david_angle_find_2(x_start,x_end,y_start,y_end,n_angles_for_test)
% radius=david_euclid_dist(x_start,x_end,y_start,y_end);
% % n_angles=3600;
% angle=linspace(0,2*pi,n_angles_for_test);
% best_dist=inf;
% for i=1:n_angles_for_test
%     candidate_x=x_end + radius*cos(angle(i));
%     candidate_y=y_end + radius*sin(angle(i));
%     if david_euclid_dist(x_start,candidate_x,y_start,candidate_y)<best_dist
%         best_dist=david_euclid_dist(x_start,candidate_x,y_start,candidate_y);
%         best_x=candidate_x;
%         best_y=candidate_y;
%         best_angle=angle(i);
%     end
% end


% function ed = david_euclid_dist(x1,x2,y1,y2)
% ed = sqrt((x1-x2)^2 + (y1-y2)^2)


% Program calling david_arrow
close all
clear all
commandwindow
clc

n=1;
hold on
x_start(1)=0;
x_end(1)=1;
y_start(1)=-1;
y_end(1)=0;
n_angles_for_test=3600;
for i=1:n
    if i>1
        x_start(i)=x_end(i-1);
        x_end(i)=x_end(i-1)+1;
        y_start(i)=y_end(i-1);
        y_end(i)=y_end(i-1)+1;
    end
    arrow_radius=.2;
    arrow_radius_coef=.5;
    arrow_angle=pi;
    shaft_descriptor='k-';
    david_arrow(x_start(i),x_end(i),...
        y_start(i),y_end(i),arrow_radius,arrow_radius_coef,...
        arrow_angle,shaft_descriptor,n_angles_for_test)
end

%% 8.9.5 Solved Problem Code
% function david_arrow(x_start,x_end,y_start,y_end,arrow_radius,arrow_radius_coef,...
%     arrow_angle,shaft_descriptor,n_angles_for_test)
% best_angle=david_angle_find_2(x_start,x_end,y_start,y_end,n_angles_for_test);
% hold on
% plot([x_start,x_end],[y_start,y_end],shaft_descriptor)
% fill([x_end,...
%     x_end+arrow_radius*cos(best_angle-arrow_angle),...
%     x_end+arrow_radius_coef*arrow_radius*cos(best_angle),...
%     x_end+arrow_radius*cos(best_angle+arrow_angle),x_end],...
%     [y_end,...
%     y_end+arrow_radius*sin(best_angle-arrow_angle),...
%     y_end+arrow_radius_coef*arrow_radius*sin(best_angle), ...
%     y_end+arrow_radius*sin(best_angle+arrow_angle),y_end],...
%     [.82 .82 .82]); %'k');
 
% function best_angle=david_angle_find_2(x_start,x_end,y_start,y_end,n_angles_for_test)
% radius=david_euclid_dist(x_start,x_end,y_start,y_end);
% % n_angles=3600;
% angle=linspace(0,2*pi,n_angles_for_test);
% best_dist=inf;
% for i=1:n_angles_for_test
%     candidate_x=x_end + radius*cos(angle(i));
%     candidate_y=y_end + radius*sin(angle(i));
%     if david_euclid_dist(x_start,candidate_x,y_start,candidate_y)<best_dist
%         best_dist=david_euclid_dist(x_start,candidate_x,y_start,candidate_y);
%         best_x=candidate_x;
%         best_y=candidate_y;
%         best_angle=angle(i);
%     end
% end

close all
clear all
commandwindow
clc

n=1;
hold on
x_start(1)=0;
x_end(1)=1;
y_start(1)=-1;
y_end(1)=0;
n_angles_for_test=3600;
for i=1:n
    if i>1
        x_start(i)=x_end(i-1);
        x_end(i)=x_end(i-1)+1;
        y_start(i)=y_end(i-1);
        y_end(i)=y_end(i-1)+1;
    end
    arrow_radius=.2;
    arrow_radius_coef=.5;
    arrow_angle=pi/10;
    shaft_descriptor='k-';
    arrow_color=[.8 .2 .5]; % red, green, blue, proportions
    david_arrow_3(x_start(i),x_end(i),y_start(i),y_end(i),arrow_radius,arrow_radius_coef,...
        arrow_angle,shaft_descriptor,arrow_color,n_angles_for_test)
end

%% 8.10.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

% % Bob_Criteria
% favorite_shape='s';
% favorite_color='r';
% favorite_size=18;

% % Betty_Criteria
% favorite_shape='p';
% favorite_color='b';
% favorite_size=44;


user='Bob';
switch user
    case 'Bob'
        eval(Bob_Criteria);
    case 'Betty'
        eval(Betty_Criteria);
end


max_n=10;
hold on
axis off
for i=1:max_n
    x(i)=randi(max_n,1);
    y(i)=randi(max_n,1);
    plot(x,y,[favorite_color,favorite_shape],'markersize',favorite_size)
end

%% 8.10.5 Solved Problem Code
clear all
close all
commandwindow
clc

% % Bob_Criteria
% favorite_shape='s';
% favorite_color='r';
% favorite_size=18;

% % Betty_Criteria
% favorite_shape='p';
% favorite_color='b';
% favorite_size=44;


user='Betty';
switch user
    case 'Bob'
        eval('Bob_Criteria');
    case 'Betty'
        eval('Betty_Criteria');        
    case 'Justin'
        eval('Justin_Criteria')
end

max_n=10;
hold on
axis off
for i=1:max_n
    x(i)=randi(max_n,1);
    y(i)=randi(max_n,1);
    plot(x,y,[favorite_color, favorite_shape],'markersize',favorite_size)
end
