%% MATLAB_BLUES_Chapter_9_Code_v9007.m

%% 9.1.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

mfc=['b';'w';'r'];  % markerfacecolor array
hold on
for i=1:3
    for j=1:3
        d(i,j)=i+j;
    end
    plot(d(i,:),...
        'k-o','markerfacecolor',mfc(i),'displayname',['x = ' num2str(i)])
end
legend ('show','location','northwest')
set(gca,'xtick',[1:3])
xlim([0 4])
ylim([min(min(d))-1 max(max(d))+1])
xlabel('x')
ylabel('y')

%% 9.1.5 Solved Problem Code
clear all
close all
commandwindow
clc
mfc=['b';'w';'r']; % markerfacecolor array
hold on
for i=3:-1:1
    for j=1:3
        d(i,j)=i+j;
    end
    plot(d(i,:),...
        'k-o','markerfacecolor',mfc(i),'displayname',['x = ' num2str(i)])
end
legend ('show','location','northwest')
set(gca,'xtick',[1:3])
xlim([0 4])
ylim([min(min(d))-1 max(max(d))+1])
xlabel('x')
ylabel('y')

%% 9.2.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

x=[-6:.01:6]; % a range of values to generate a logistic curve
x_shift=[-2 0 2];
alpha=1;
for i=1:3
    y=(1+exp(alpha*(x_shift(i)-x))).^-1; % logistic curve   
    hold on % to plot more than one curve in the graph
    if i==1
        plot(x,y,'b-','linewidth',2,'displayname','A easier than B')
    elseif i==2
        %  plot(x,y,'g-','linewidth',2,'displayname','A as easy as B') 
        plot(x,y,'--','linewidth',2,'color',[1 1 1]*.6)       
    elseif i==3
         plot(x,y,'r-','linewidth',2,'displayname','A harder than B')
    end
end
set(gca,'xticklabel',num2str(linspace(0,1,7)',2));
ylabel('p(B judged easier than A)')
xlabel('n_AA / (n_AA + n_BB)')
grid on
box on
legend ('show','location','northwest')

%% 9.2.5 Solved Problem Code
clear all
close all
commandwindow
clc

x=[-6:.01:6]; % a range of values to generate a logistic curve
x_shift=[-2 0 2];
alpha=1;
for i=1:3
    y=(1+exp(alpha*(x_shift(i)-x))).^-1; % logistic curve   
    hold on % to plot more than one curve in the graph
    if i==1
        p1=plot(x,y,'b-','linewidth',2)
    elseif i==2
        p2=plot(x,y,'--','linewidth',2,'color',[1 1 1]*.6)
    elseif i==3
        p3=plot(x,y,'r-','linewidth',2)
    end
end
set(gca,'xticklabel',num2str(linspace(0,1,7)',2));

want_3=false; % grant the option of showing legend for three curves or two (p1 and p3 in particular)
if want_3
    legend([p1 p2 p3],...
        {'A easier than B';'A as easy as B';...
        'A harder than B'},'location','east')
else
    legend([p1 p3],{'A easier than B';'A harder than B'},'location','east')
end

ylabel('p(B judged easier than A)')
xlabel('n_AA / (n_AA + n_BB)')
grid on
box on
set(legend,'location','northwest')

%% 9.3.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

mfc=['b';'w';'r']; % markerfacecolor array
hold on
for i=3:-1:1
    for j=1:3
        d(i,j)=i+j;
    end
    plot(d(i,:), ...
        'k-o','markerfacecolor',mfc(i),'displayname',['\ital \alpha = ' num2str(i)])
end
legend ('show','location','northwest')
set(gca,'xtick',[1:3])
xlim([0 4])
ylim([min(min(d))-1 max(max(d))+1])
fs=16; % fontsize
xlabel('\ital \alpha','fontsize',fs,'fontweight','bold')
ylabel('\ital \beta','fontsize',fs,'fontweight','bold')

%% 9.3.5 Solved Problem Code
clear all
close all
commandwindow
clc

mfc=['b';'w';'r'];  % markerfacecolor array
hold on
for i=3:-1:1
    for j=1:3
        d(i,j)=i+j;
    end
    plot(d(i,:),...
        'k-o','markerfacecolor',mfc(i),'displayname',['\it \alpha = ' num2str(i)])
end
legend ('show','location','northwest')
set(gca,'xtick',[1:3])
xlim([0 4])
ylim([min(min(d))-1 max(max(d))+1])
fs=16; % fontsize
xlabel('\it \alpha','fontsize',fs,'fontweight','bold')
ylabel('\beta','fontsize',fs,'fontweight','bold','fontangle', 'ital')

%% 9.4.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n=20;
stdev=.15;
ms=3; % markersize
r(1:20,1:2)=NaN;
for i=1:n
    g=abs(randn); h=abs(randn);
    r(i,1:2)=[g g+(h*stdev)];
end
r
disp(' ')
subplot(1,2,1)
plot(r(1:n,1),r(1:n,2),'ko-','markersize',ms,...
    'markerfacecolor','w')
c=corrcoef(r(1:n,1),r(1:n,2));
XL=xlim
YL=ylim
% show correlation only with value to right of the decimal
text(XL(1)+.1*(XL(2)-XL(1)), YL(1)+.9*(YL(2)-YL(1)), ['r = ' num2str(c(1,2),2)]);

subplot(1,2,2)
plot(1:n,r(1:n,2),'ko-','markersize',ms,...
    'markerfacecolor','w')
c=corrcoef(1:n,r(1:n,2));
XL=xlim
YL=ylim
% show correlation only with value to right of the decimal
text(XL(1)+.1*(XL(2)-XL(1)), YL(1)+.9*(YL(2)-YL(1)), ['r = ' num2str(c(1,2),2)]);

%% 9.4.5 Solved Problem Code
clear all
close all
commandwindow
clc

n=20;
stdev=.15;
ms=3; % markersize
r(1:20,1:2)=NaN;
for i=1:n
    g=abs(randn); h=abs(randn);
    r(i,1:2)=[g g+(h*stdev)];
end
r
disp(' ')
subplot(1,2,1)
plot(r(1:n,1),r(1:n,2),'ko-','markersize',ms,...
    'markerfacecolor','w')
c=corrcoef(r(1:n,1),r(1:n,2));
XL=xlim
YL=ylim
% show correlation only with value to right of the decimal
text(XL(1)+.1*(XL(2)-XL(1)), YL(1)+.9*(YL(2)-YL(1)), ['r = ' num2str(c(1,2),2)]);

subplot(1,2,2)
sr=sortrows(r,1);
plot(sr(1:n,1),sr(1:n,2),'ko-','markersize',ms,...
    'markerfacecolor','w')
c=corrcoef(r(1:n,1),r(1:n,2));
XL=xlim
YL=ylim
% show correlation only with value to right of the decimal
text(XL(1)+.1*(XL(2)-XL(1)), YL(1)+.9*(YL(2)-YL(1)), ['r = ' num2str(c(1,2),2)]);

%% 9.5.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

polygon_text(4).pt='Square';
polygon_text(5).pt='Pentagon';
polygon_text(6).pt='Hexagon';
font_size=18;

for n_corners=4:6
    angle=linspace(0,2*pi,n_corners);
    if rem(n_corners,2)==1
        number_title_status='on';
    else
        number_title_status='off';
    end
    fg=figure('name',['n_corners = ', ...
        num2str(n_corners)],'numbertitle',number_title_status)
    hold on
    fill(cos(angle),sin(angle),'w')
    plot(cos(angle),sin(angle),'o','markerfacecolor','y',...
        'markeredgecolor','b','markersize',14)
    text(0,0,polygon_text(n_corners).pt,...
        'horizontalalignment','center', ...
        'fontsize',font_size)
    axis equal
    axis off
end

%% 9.5.5 Solved Problem Code
clear all
close all
commandwindow
clc

polygon_text(4).pt='Square';
polygon_text(5).pt='Pentagon';
polygon_text(6).pt='Hexagon';
font_size=18;

for n_corners=4:6
    angle=linspace(0,2*pi,n_corners+1);
    if rem(n_corners,2)==0
        number_title_status='off';
    else
        number_title_status='on';
    end
    fg=figure('name',['n_corners = ', ...
        num2str(n_corners)],'numbertitle',number_title_status)
    hold on
    fill(cos(angle),sin(angle),'w')
    plot(cos(angle),sin(angle),'o','markerfacecolor','y',...
        'markeredgecolor','b','markersize',14)
    text(0,0,polygon_text(n_corners).pt,...
        'horizontalalignment','center', ...
        'fontsize',font_size)
    axis equal
    axis off
end

%% 9.6.2 Solved Problem Code (No unsolved code)
clear all
close all
commandwindow
clc

a=.9  % probability of yes at level 1
b=.9  % probability of yes at level 2 if said yes at level 1
c=.2  % probability of yes at level 2 if said no at level 1

s=1000;       % number of simulations
alpha=10;     % exponent for bump used to generate (RTs 10 makes a hump with flat edges)
k=1*10^8;     % constant for bump used to generate RTs
min_RT=200;   % another constant for bump used to generate RTs
brighten=.80; % for bar graphs

%%% Run simulations and get summaries
summary_1=[];
for ai=1:size(a,2)
    for bi=1:size(b,2)
        for ci=1:size(c,2)
            for si=1:s
                
                % level 1
                rand_draw_1(si,1)=rand;
                if rand_draw_1(si,1)<a(ai)
                    response_1(si,1)=1;
                else
                    response_1(si,1)=0;
                end
                p_for_bump_1(si,1)=.5*((rand_draw_1(si,1)-a(ai))+1); % bring range from -1 1 to 0 1
                q_for_bump_1(si,1)=1-p_for_bump_1(si,1);
                RT_1(si,1)=min_RT+...
                    k*((p_for_bump_1(si,1)^alpha)* ...
                    (q_for_bump_1(si,1)^alpha));
                
                % level 2 if yes at level 1
                rand_draw_2(si,1)=rand;
                if rand_draw_2(si,1)<b(bi)
                    response_2(si,1)=1;
                else
                    response_2(si,1)=0;
                end
                p_for_bump_2(si,1)=...
                    .5*((rand_draw_2(si,1)-b(bi))+1); % bring range from -1 1 to 0 1
                q_for_bump_2(si,1)=1-p_for_bump_2(si,1);
                RT_2(si,1)= ...
                    min_RT+k*((p_for_bump_2(si,1)^alpha)* ...
                    (q_for_bump_2(si,1)^alpha));
                
                % level 2 if no at level 1
                rand_draw_3(si,1)=rand;
                if rand_draw_3(si,1)<c(ci)
                    response_3(si,1)=1;
                else
                    response_3(si,1)=0;
                end
                p_for_bump_3(si,1)= ...
                    .5*((rand_draw_3(si,1)-c(ci))+1); % bring range from -1 1 to 0 1
                q_for_bump_3(si,1)=1-p_for_bump_3(si,1);
                RT_3(si,1)=min_RT+k*((p_for_bump_3(si,1)^alpha)* ...
                    (q_for_bump_3(si,1)^alpha));
                
            end
        end
    end
end

% summary of level 1
summary_1=[rand_draw_1 p_for_bump_1 q_for_bump_1 response_1 RT_1];
mean(summary_1)
figure(1)
subplot(2,1,1)
hist(summary_1(:,end))
colormap([1 1 1]*brighten)
title(['Level 1 RTs (p = ',num2str(a(ai),2),')']);%,'fontweight','normal')
subplot(2,1,2)
% plot(summary_1(:,1),summary_1(:,end),'k.') % just doing this left holes,
% so sortrows and use line instead
data_of_interest=summary_1(:,[1 end]);
data_of_interest=sortrows(data_of_interest,1);
plot(data_of_interest(:,1),data_of_interest(:,2),'k-','linewidth',1.2);

% summary of level 2
summary_2=[rand_draw_2 p_for_bump_2 q_for_bump_2 response_2 RT_2];
mean(summary_2)
figure(2)
subplot(2,1,1)
hist(summary_2(:,end))
colormap([1 1 1]*brighten)
title(...
    ['Level 2 RTs if Yes at Level 1 (p = ',num2str(b(bi),2),')']);
subplot(2,1,2)
plot(summary_2(:,1),summary_2(:,end),'k.')  % just doing this left holes,
% so sortrows and use line instead
clear data_of_interest
data_of_interest=summary_2(:,[1 end]);
data_of_interest=sortrows(data_of_interest,1);
plot(data_of_interest(:,1),data_of_interest(:,2), ...
    'k-','linewidth',1.2);

% summary of level 3
summary_3=[rand_draw_3 p_for_bump_3 q_for_bump_3 response_3 RT_3];
mean(summary_3)
figure(3)
subplot(2,1,1)
hist(summary_3(:,end))
colormap([1 1 1]*brighten)
title(...
    ['Level 3 RTs if Yes at Level 1 (p = ',num2str(c(ci),2),')']);
subplot(2,1,2)
plot(summary_3(:,1),summary_3(:,end),'k.') % just doing this left holes,
% so sortrows and use line instead
clear data_of_interest
data_of_interest=summary_3(:,[1 end]);
data_of_interest=sortrows(data_of_interest,1);
plot(data_of_interest(:,1),data_of_interest(:,2),'k-','linewidth',1.2);

%%% Combine the summaries to get responses and RTs per simulation.
% Have three possible composite responses: yes, no, and maybe.
% RTs can be gotten for each composite response. Because the sizes of the
% three summaries are identical, we can use the size of any to set the
% length of the for loop.
yes_summary=[];
maybe_summary=[];
no_summary=[];
for si=1:size(summary_1,1)
    if summary_1(si,4)==1 & summary_2(si,4)==1  % yes at both levels
        yes_summary=[yes_summary; summary_1(si,5)+summary_2(si,5)];
    elseif summary_1(si,4)==0 & summary_3(si,4)==0  % no at both levels
        no_summary=[no_summary; summary_1(si,5)+summary_2(si,5)];
    elseif summary_1(si,4)==1 & summary_2(si,4)==0  % yes, then no
        maybe_summary=[maybe_summary; summary_1(si,5)+summary_2(si,5)];
    elseif summary_1(si,4)==0 & summary_3(si,4)==1  % no then yes
        maybe_summary=[maybe_summary; summary_1(si,5)+summary_3(si,5)];
    end
end
yes_summary;
size(yes_summary)
proportion_yes=size(yes_summary)/sum([size(yes_summary),...
    size(maybe_summary),size(no_summary)])
no_summary;
size(no_summary)
proportion_no=size(no_summary)/sum([size(yes_summary), ...
    size(maybe_summary),size(no_summary)])
maybe_summary;
size(maybe_summary)
proportion_maybe=size(maybe_summary)/sum([size(yes_summary),...
    size(maybe_summary),size(no_summary)])

%%% Plot RTs for Yes, Maybe, and No
figure(4)
text_height=.6*max([mean(yes_summary),...
    mean(maybe_summary),mean(no_summary)]);
fs=12; % fontsize
hold on
bar(1,mean(yes_summary))
errorbar(1,mean(yes_summary),std(yes_summary),'k-')
text(1,text_height,num2str(proportion_yes(1), ...
    '%2.2f'),'fontsize',fs,'horizontalalignment','center')
bar(2,mean(maybe_summary))
errorbar(2,mean(maybe_summary),std(maybe_summary),'k-')
text(2,text_height,num2str(proportion_maybe(1), ...
    '%2.2f'),'fontsize',fs,'horizontalalignment','center')
bar(3,mean(no_summary))
errorbar(3,mean(no_summary),std(no_summary),'k-')
text(3,text_height,num2str(proportion_no(1), ...
    '%2.2f'),'fontsize',fs,'horizontalalignment','center')
colormap([1 1 1].*brighten)
set(gca,'ytick',[0:100:600])
ylabel('RT (ms)')
set(gca,'xtick',[1 2 3])
set(gca,'xticklabel',{'Yes';'Maybe';'No'})  % use braces because these words are of different length
box on

%%% Plot RT as a function of proportion
figure(5)
ms=11;
legend_font_size=12;
hold on
clear x y
x=[proportion_no(1),proportion_yes(1),proportion_maybe(1)];
y=[mean(no_summary),mean(yes_summary),mean(maybe_summary)];
% Plot the three points in the order below so legend words are arranged
% this way from top to bottom for good stimulus-response compatibility
plot(x(1),y(1),'ko','markersize',ms,...
    'markerfacecolor','r','displayname','No');
plot(x(3),y(3),'ko','markersize',ms, ...
    'markerfacecolor','b','displayname','Maybe');
plot(x(2),y(2),'ko','markersize',ms,...
    'markerfacecolor','g','displayname','Yes');
legend('show','location','northeast')
get(legend) % print this out to see which aspects of legend can be specified
set(legend,'FontSize',legend_font_size,'color','w')
xlabel('Proportion')
ylabel('RT (ms)')
grid on
box on
xlim([0 1])

%%% Diagram the choice probabilities
x_prop=1/5;
y_prop=1/5;
figure(6)
hold on
n=6;
hold on
arrow_length=[.65 .50]  % need two arrow lengths for the two stages; otherwise the arrows collide
arrow_angle_yes=pi/4;
arrow_angle_no=-arrow_angle_yes;
ms=18; % markersize
mh=.6; % maxheadsize for quiver
fs=11; % fontsize
horiz_text_shift=.01;

x_start(1)=0;
y_start(1)=0;
x_end(1)=x_start(1)+cos(arrow_angle_yes)*arrow_length(1);
y_end(1)=y_start(1)+sin(arrow_angle_yes)*arrow_length(1);
x_start(2)=0;
y_start(2)=0;
x_end(2)=x_start(1)+cos(arrow_angle_no)*arrow_length(1);
y_end(2)=y_start(1)+sin(arrow_angle_no)*arrow_length(1);
x_start(3)=x_end(1);
y_start(3)=y_end(1);
x_end(3)=x_start(3)+cos(arrow_angle_yes)*arrow_length(2);
y_end(3)=y_start(3)+sin(arrow_angle_yes)*arrow_length(2);
x_start(4)=x_end(1);
y_start(4)=y_end(1);
x_end(4)=x_start(4)+cos(arrow_angle_no)*arrow_length(2);
y_end(4)=y_start(4)+sin(arrow_angle_no)*arrow_length(2);
x_start(5)=x_end(2);
y_start(5)=y_end(2);
x_end(5)=x_start(5)+cos(arrow_angle_yes)*arrow_length(2);
y_end(5)=y_start(5)+sin(arrow_angle_yes)*arrow_length(2);
x_start(6)=x_end(2);
y_start(6)=y_end(2);
x_end(6)=x_start(6)+cos(arrow_angle_no)*arrow_length(2);
y_end(6)=y_start(6)+sin(arrow_angle_no)*arrow_length(2);

for i=1:n
    qv=quiver(x_start(i),y_start(i),...
        x_end(i)-x_start(i),y_end(i)-y_start(i),0,'color','k','maxheadsize',mh,...
        'MarkerFaceColor','k')
    x_term=[x_start(i)+x_prop*(x_end(i)-x_start(i)),...
        x_end(i)-x_prop*(x_end(i)-x_start(i))];
    y_term=[y_start(i)+y_prop*(y_end(i)-y_start(i)),...
        y_end(i)-y_prop*(y_end(i)-y_start(i))];
    plot(x_term,y_term,'w');
    plot(x_start(i),y_start(i),'k.','markersize',ms)
end
axis off
axis equal

% yes level 1
x_start(1)=0;
y_start(1)=0;
x_end(1)=x_start(1)+cos(arrow_angle_yes)*arrow_length(1);
y_end(1)=y_start(1)+sin(arrow_angle_yes)*arrow_length(1);
text(x_start(1)+cos(arrow_angle_yes)*arrow_length(1)/2,...
    y_start(1)+sin(arrow_angle_yes)*arrow_length(1)/2,['p = ' num2str(a)],...
    'horizontalalignment','center','rotation',45);

% no level 1
x_start(2)=0;
y_start(2)=0;
x_end(2)=x_start(1)+cos(arrow_angle_no)*arrow_length(1);
y_end(2)=y_start(1)+sin(arrow_angle_no)*arrow_length(1);
text(x_start(2)+cos(arrow_angle_no)*arrow_length(1)/2,...
    y_start(2)+sin(arrow_angle_no)*arrow_length(1)/2,...
    ['1-p = ' num2str(1-a)],...
    'horizontalalignment','center','rotation',-45);

% yes at level 2 after yes at level 1
x_start(3)=x_end(1);
y_start(3)=y_end(1);
x_end(3)=x_start(3)+cos(arrow_angle_yes)*arrow_length(2);
y_end(3)=y_start(3)+sin(arrow_angle_yes)*arrow_length(2);
text(x_start(3)+cos(arrow_angle_yes)*arrow_length(2)/2,...
    y_start(3)+sin(arrow_angle_yes)*arrow_length(2)/2, ...
    ['p = ' num2str(b)],...
    'horizontalalignment','center','rotation',45);
text(x_end(3)+horiz_text_shift,y_end(3),'Yes', ...
    'fontsize',fs,'fontangle','ital')

% no at level 2 after yes at level 1
x_start(4)=x_end(1);
y_start(4)=y_end(1);
x_end(4)=x_start(4)+cos(arrow_angle_no)*arrow_length(2);
y_end(4)=y_start(4)+sin(arrow_angle_no)*arrow_length(2);
text(x_start(4)+cos(arrow_angle_no)*arrow_length(2)/2,...
    y_start(4)+sin(arrow_angle_no)*arrow_length(2)/2, ...
    ['1-p = ' num2str(1-a)],...
    'horizontalalignment','center','rotation',-45);
text(x_end(4)+horiz_text_shift,y_end(4),'Maybe', ...
    'fontsize',fs,'fontangle','ital')

% yes at level 2 after no at level 1
x_start(5)=x_end(2);
y_start(5)=y_end(2);
x_end(5)=x_start(5)+cos(arrow_angle_yes)*arrow_length(2);
y_end(5)=y_start(5)+sin(arrow_angle_yes)*arrow_length(2);
text(x_start(5)+cos(arrow_angle_yes)*arrow_length(2)/2,...
    y_start(5)+sin(arrow_angle_yes)*arrow_length(2)/2,...
    ['p = ' num2str(b)],...
    'horizontalalignment','center','rotation',45);
text(x_end(5)+horiz_text_shift,y_end(5),'Maybe',...
    'fontsize',fs,'fontangle','ital')

% no at level 2 after no at level 1
x_start(6)=x_end(2);
y_start(6)=y_end(2);
x_end(6)=x_start(6)+cos(arrow_angle_no)*arrow_length(2);
y_end(6)=y_start(6)+sin(arrow_angle_no)*arrow_length(2);
text(x_start(6)+cos(arrow_angle_no)*arrow_length(2)/2,...
    y_start(6)+sin(arrow_angle_no)*arrow_length(2)/2, ...
    ['1-p = ' num2str(1-a)],...
    'horizontalalignment','center','rotation',-45,'fontangle','ital');
text(x_end(6)+horiz_text_shift,y_end(6),...
    'No','fontsize',fs,'fontangle','ital')

%% 9.7.2 Solved Problem Code (No unsolved code)
clear all
close all
commandwindow
clc

% Conventions used here for the coordinates
% x == left-right
% y == in-out
% z == up-down

% Point
%  1 left hip front
%  2 left hip back
%  3 left shoulder front
%  4 left shoulder back
%  5 right hip front
%  6 right hip back
%  7 right shoulder front
%  8 right shoulder back
%  9 left elbow
% 10 left wrist
% 11 right elbow
% 12 right wrist

graph_lim=7;
XMIN=-graph_lim;
XMAX=graph_lim;
YMIN=-graph_lim;
YMAX=graph_lim;
ZMIN=-1;
ZMAX=graph_lim;
np=12; % number of points
r(1:np)=2; % radius from parent point
beta_range=2*pi;   % azimuth
alpha_range=2*pi;  % elevation
delta_prop_length=.001;  % for checking that a limb segment goes into the torso
ni=8; % number of iterations

% assign p values to torso corners
LHF=5;  % left hip front
RHF=6;  % right hip front
RSF=7;  % right shoulder front
LSF=8;  % left shoulder front

LHB=1;  % left hip front
RHB=2;  % right hip front
RSB=3;  % right shoulder front
LSB=4;  % left shoulder front

% assign coordinates to torso corners
x(LHF)=0; y(LHF)=0; z(LHF)=0;  % left hip front
x(RHF)=0; y(RHF)=1; z(RHF)=0;  % right hip front
x(RSF)=0; y(RSF)=1; z(RSF)=3;  % right shoulder front
x(LSF)=0; y(LSF)=0; z(LSF)=3;  % left shoulder front

x(LHB)=1; y(LHB)=0; z(LHB)=0;  % left hip back
x(RHB)=1; y(RHB)=1; z(RHB)=0;  % right hip back
x(RSB)=1; y(RSB)=1; z(RSB)=3;  % right shoulder back
x(LSB)=1; y(LSB)=0; z(LSB)=3;  % leBt shoulder back

ms=24; % markersize

S=[];  % intialize S, where lots of data will be stored
S_short=[]; % intialize S_short, where less data will be stored

for i=1:ni
  
    figure(1)
    set(gca,'CameraPosition',[-68.548 -82.884 34.976]);
    hold on
    axis([XMIN XMAX YMIN YMAX ZMIN ZMAX])
    
    % draw front, back, left, and right sides  
    light_blue_color=[.5 .5 .9];  
   
    fill3(x([LHB RHB RSB LSB]),...
        y([LHB RHB RSB LSB]),...
        z([LHB RHB RSB LSB]),'w')  %back
    fill3(x([LHF RHF RSF LSF]),...
        y([LHF RHF RSF LSF]),...
        z([LHF RHF RSF LSF]),'y')  %front
    fill3(x([RHF RHB RSB RSF]),...
        y([RHF RHB RSB RSF]),...
        z([RHF RHB RSB RSF]),'r')  %right
    fill3(x([LHF LHB LSB LSF]),...
        y([LHF LHB LSB LSF]),...
        z([LHF LHB LSB LSF]),...
        light_blue_color) %left
    
    % Generate possible left and right arm positions that don't enter the
    % torso. Point, p,
    % 9 is left shoulder
    % 10 is left elbow
    % 11 is right shoulder
    % 12 is right elbow
    
    intersect_check=0; % initialize counter for number of random samples needed
    intersects=true; % intialize the bad condition to be escaped
    while intersects==true
        % start off on an optimistic foot, have it go bad and try again if needed
        intersects=false;
        for p=9:12
            beta(p)=rand*beta_range;
            alpha(p)=rand*alpha_range;
            if p==9
                origin=LSF;
            elseif p==11
                origin=RSF;
            else
                origin=p-1;
            end
            x(p)=x(origin)+r(origin)*cos(beta(p))*sin(alpha(p));
            y(p)=y(origin)+r(origin)*cos(beta(p))*cos(alpha(p));
            z(p)=z(origin)+r(origin)*sin(beta(p));         
            
            % Does any segment enter the torso?
            for prop_length=0:delta_prop_length:1
                candidate_x=x(origin)+...
                    prop_length*(x(p)-x(origin));
                candidate_y=y(origin)+...
                    prop_length*(y(p)-y(origin));
                candidate_z=z(origin)+...
                    prop_length*(z(p)-z(origin));
                
                if ...
                        candidate_x>min(x(1:8)) & ...
                        candidate_x<max(x(1:8)) & ...
                        candidate_y>min(y(1:8)) & ...
                        candidate_y<max(y(1:8)) & ...
                        candidate_z>min(z(1:8)) & ...
                        candidate_z<max(z(1:8))
                    intersects=true;
                end
                
            end  %for prop_length=0:delta_prop_length:1
            
        end % for p=9:12
    end  %  while intersects==true
    
    % Draw the arms
    hold on 
    
    plot3(x([LSF 9 10]),y([LSF 9 10]),z([LSF 9 10]),...
        'b.-','markersize',ms)   
    plot3(x([RSF 11 12]),y([RSF 11 12]),z([RSF 11 12]),...
        'r.-','markersize',ms)
    axis([XMIN XMAX YMIN YMAX ZMIN ZMAX])
    grid on
    xlabel('x')
    ylabel('y')
    zlabel('z')
    
    % Have user hit j key if posture possible or f key if not. In this
    % case, david_ginput is used to suppress the crosshairs, as discussed
    % in Problem xxxxxxx. Altneratively, it would be possible to use
    % ginput.
    b=[]; % the variable for the button press
    tic
    while isempty(b)
        acceptable_input=false;
        while acceptable_input==false
            [gx gy b]=david_ginput(1);
            if b==106 | b==102  % if b is f (bad) or j (good)
                acceptable_input=true;
                if b==106
                    status=1;
                elseif b==102
                    status=0;
                end
            end
        end
    end
    S=[S;i x y z alpha beta status toc];
    S_short=[S_short;i beta(9:12) alpha(9:12) status toc];
    
    % close figure window if more tests to go
    if i<ni
        close
    end
    
end  % for i=1:ni

S_short

%  Graph the successful (blue) and unsuccessful (red) azimuth-elevation pairs
%  Only need to get one such pair per 2-arm posture since, for now, the
%  right arm has the same shoulder and elbow angles (defined in extrinsic
%  spatial coordinates) as the left arm.

figure(2)
for sb=1:2
    subplot(1,2,sb)
    if sb==1
        title('Shoulder','fontweight','normal')
        relevant_beta_columns=2;
    else
        title('Elbow','fontweight','normal')
        relevant_beta_columns=3;
    end
    ylabel('Elevation (radians)')
    xlabel('Azimuth (radians)')
    axis([0 2*pi 0 2*pi])
    ms=8; % markersize
    box on
    grid on
    hold on
    for si=1:size(S_short,1)
        for col=relevant_beta_columns
            if S_short(si,end-1)==0
                plot(S_short(si,col),S_short(si,col+4),...
                    'r*','markersize',ms);
            elseif S_short(si,end-1)==1
                plot(S_short(si,col),S_short(si,col+4),...
                    'b*','markersize',ms);
            end
        end % for col=2:5
    end % for si=1:size(S_short,1)
end

%% 9.8.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

pic = imread('pic Benny & Papa 10-29-17.JPG');
image(pic);
axis off
[x y]=ginput(2) % click on the outer corners of the desired frame
kept_part_of_pic = imcrop(pic, [x(1) x(2) y(1) y(2)]);
image(kept_part_of_pic)
axis off

%% 9.8.5 Solved Problem Code
clear all
close all
commandwindow
clc

pic = imread('pic Benny & Papa 10-29-17.JPG');
image(pic);
axis off
[x y]=ginput(2)
kept_part_of_pic = imcrop(pic, [min(x) min(y) max(x)-min(x) max(y)-min(y)]);
image(kept_part_of_pic)
axis off

%% 9.9.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

pic(1).pct='pic fMRI for blog (02) 08-08-17.jpg';
pic(2).pct='pic Benny & Papa 10-29-17.JPG';
pic(3).pct='pic statues.jpg';
pic(4).pct='pic old-people-in-forest-4928x3264_72022.jpg';
pic(5).pct='pic touch-1661620-2.jpg';

% Show the original four images
figure(1)
for sb=1:4
    ax(sb) = subplot(2,2,sb);
    imshow(pic(sb).pct);
    axis off
    hold on
end
ginput(1)
% clickedAx = gca  % the clicked axes are gca, just confirming that here
axnum = (ismember(ax, gca)); % find the subplot number for the clicked axes

% In the next figure window, replace the image that was clicked with a new
% image and re-show the images that were not clicked. It turns out to be
% easier to do this in a new figure window than to do it in the same figure
% window because weird image resizing problems arise in the same-window
% case.

figure(2)
for sb=1:4
    ax(sb) = subplot(2,2,sb)
    if sb~=axnum  % if this subplot not the one that was clicked, show same image as before
        imshow(pic(sb).pct);
    else % if this subplot is the one that was clicked, show different image at the subplot
        imshow(pic(5).pct);
    end
    axis off
    hold on
end

%% 9.9.5 Solved Problem Code
clear all
close all
commandwindow
clc

pic(1).pct='pic fMRI for blog (02) 08-08-17.jpg';
pic(2).pct='pic Benny & Papa 10-29-17.JPG';
pic(3).pct='pic statues.jpg';
pic(4).pct='pic old-people-in-forest-4928x3264_72022.jpg';
pic(5).pct='pic touch-1661620-2.jpg';

% Show the original four images
figure(1)
for sb=1:4
    ax(sb) = subplot(2,2,sb);
    imshow(pic(sb).pct);
    axis off
    hold on
end
ginput(1)
% clickedAx = gca  % the clicked axes are gca, just confirming that here
% Bad (incomplete) code
% axnum = (ismember(ax, gca)); % find the subplot number for the clicked axes
% Good (complete) code
axnum = find(ismember(ax, gca)); % find the subplot number for the clicked axes

% In the next figure window, replace the image that was clicked with a new
% image and re-show the images that were not clicked. It turns out to be
% easier to do this in a new figure window than to do it in the same figure
% window because weird image resizing problems arise in the same-window
% case.

figure(2)
for sb=1:4
    ax(sb) = subplot(2,2,sb)
    if sb~=axnum  % if this subplot not the one that was clicked, show same image as before
        imshow(pic(sb).pct);
    else % if this subplot is the one that was clicked, show different image at the subplot
        imshow(pic(5).pct);
    end
    axis off
    hold on
end

%% 9.10.2 Unsolved Problem Code
clear all
close all
commandwindow
clc

n_samples_per_angle=20;
n_cycles=4;
n_all_angles=n_cycles*n_samples_per_angle;
sample_angle=linspace(0,n_cycles*2*pi,n_all_angles);

x_circle_center=0;
y_circle_center=1.5;
line_thickness=1;
trig_line_thickness=line_thickness*1.2;
radius=1;
dot_size=16;
x_bound=3;
y_bound=3;
pause_time=.05;
xlim([-x_bound x_bound]);
ylim([-y_bound y_bound]);
XLim(1:2)=[-x_bound x_bound];
YLim(1:2)=[-y_bound y_bound];
y_for_cosine_graph=-1;
y_for_sine_graph=-2;
T=n_all_angles;
graph_scalar=.25;
n_displays=4;

for dp=1:n_displays
    tic % start timer to record display_time(dp)
    for i=1:n_all_angles
        hold on
        axis equal
        axis off
        
        % plot circle center
        plot(x_circle_center, ...
            y_circle_center, ...
            'k.','markersize',dot_size)
        
        % plot circle
        plot(x_circle_center+radius*cos(sample_angle), ...
            y_circle_center+radius*sin(sample_angle),'k-')
        
        %   plot horizontal meridian
        plot([x_circle_center + radius*cos(.75*2*pi),...
            x_circle_center + radius*cos(.25*2*pi)],...
            [y_circle_center + radius*sin(.75*2*pi),...
            y_circle_center + radius*sin(.25*2*pi)],'k-')
        
        %   plot vertical meridian
        plot([x_circle_center + radius*cos(.5*2*pi),...
            x_circle_center + radius*cos(.0*2*pi)],...
            [y_circle_center + radius*sin(.5*2*pi),...
            y_circle_center + radius*sin(0*2*pi)],'k-')
        
        % plot line from circle center to current point on circle
        plot([x_circle_center x_circle_center + ...
            radius*cos(sample_angle(i))], ...
            [y_circle_center y_circle_center + ...
            radius*sin(sample_angle(i))],'k-')
              
        % plot current point on circle
        plot([x_circle_center ...
            x_circle_center+radius*cos(sample_angle(i))], ...
            [y_circle_center ...
            y_circle_center+radius*sin(sample_angle(i))], ...
            'k.','markersize',dot_size)
        
        % plot line from current point on circle to its projection on the
        % horizontal meridian
        plot([x_circle_center+radius*cos(sample_angle(i)), ...
            x_circle_center+radius*cos(sample_angle(i))], ...
            [y_circle_center+radius*sin(sample_angle(i)), ...
            y_circle_center], ...
            'b--','linewidth',line_thickness);
        
        % plot line from current point on circle to its projection on the
        % vertical meridian
        plot([x_circle_center+radius*cos(sample_angle(i)), ...
            x_circle_center], ...
            [y_circle_center+radius*sin(sample_angle(i)), ...
            y_circle_center+radius*sin(sample_angle(i))], ...
            'r--','linewidth',line_thickness);
               
        % plot cosine
        plot(-y_bound+(2*y_bound).*[1:i]./T,...
            y_for_cosine_graph+graph_scalar*cos(sample_angle(1:i)),...
            'b--','linewidth',trig_line_thickness)
        
        % plot sine
        plot(-y_bound+(2*y_bound).*[1:i]./T,...
            y_for_sine_graph+graph_scalar*sin(sample_angle(1:i)),...
            'r--','linewidth',trig_line_thickness)
        
        pause(pause_time)
        if i<n_all_angles %& dp==n_displays
            fill([XLim(1) XLim(2) XLim(2) XLim(1)], ...
                [YLim(1) YLim(1) YLim(2) YLim(2)],'w')
        end
        
    end % for i=1:n_all_angles
    
    display_time(dp)=toc; % stop timer and assign to display_time(dp)
    
end % for dp=1:n_displays
display_time

%% 9.10.5 Solved Problem Code
clear all
close all
commandwindow
clc

n_samples_per_angle=20;
n_cycles=4;
n_all_angles=n_cycles*n_samples_per_angle;
sample_angle=linspace(0,n_cycles*2*pi,n_all_angles);

x_circle_center=0;
y_circle_center=1.5;
line_thickness=1;
trig_line_thickness=line_thickness*1.2;
radius=1;
dot_size=16;
x_bound=3;
y_bound=3;
pause_time=.05;
xlim([-x_bound x_bound]);
ylim([-y_bound y_bound]);
XLim(1:2)=[-x_bound x_bound];
YLim(1:2)=[-y_bound y_bound];
y_for_cosine_graph=-1;
y_for_sine_graph=-2;
T=n_all_angles;
graph_scalar=.25;
n_displays=4;

for dp=1:n_displays
tic % start timer to record display_time(dp) 
    for i=1:n_all_angles
        hold on
        axis equal
        axis off
        
        % plot circle center
        P.cc=plot(x_circle_center, ...
            y_circle_center, ...
            'k.','markersize',dot_size);
        
        % plot circle
        P.pc=plot(x_circle_center+radius*cos(sample_angle),...
            y_circle_center+radius*sin(sample_angle),'k-');
        
        %   plot horizontal meridian
        P.hm=plot([x_circle_center + radius*cos(.75*2*pi),...
            x_circle_center + radius*cos(.25*2*pi)],...
            [y_circle_center + radius*sin(.75*2*pi),...
            y_circle_center + radius*sin(.25*2*pi)],'k-');
        
        %   plot vertical meridian
        P.vm=plot([x_circle_center + radius*cos(.5*2*pi),...
            x_circle_center + radius*cos(.0*2*pi)],...
            [y_circle_center + radius*sin(.5*2*pi),...
            y_circle_center + radius*sin(0*2*pi)],'k-');
        
        % plot line from circle center to current point on circle
       P.ccp= plot([x_circle_center x_circle_center + ...
           radius*cos(sample_angle(i))], ...
            [y_circle_center y_circle_center + ...
            radius*sin(sample_angle(i))],'k-');
        
        
        % plot current point on circle
       P.cuc= plot([x_circle_center x_circle_center + ...
           radius*cos(sample_angle(i))], ...
            [y_circle_center y_circle_center + ...
            radius*sin(sample_angle(i))], ...
            'k.','markersize',dot_size);
        
        % plot line from current point on circle to its projection on the
        % horizontal meridian
        P.c2h=plot([x_circle_center+radius*cos(sample_angle(i)), ...
            x_circle_center+radius*cos(sample_angle(i))], ...
            [y_circle_center+radius*sin(sample_angle(i)), ...
            y_circle_center], ...
            'b--','linewidth',line_thickness);
        
        % plot line from current point on circle to its projection on the
        % vertical meridian
       P.c2v= plot([x_circle_center+radius*cos(sample_angle(i)), ...
            x_circle_center], ...
            [y_circle_center+radius*sin(sample_angle(i)),...
            y_circle_center+radius*sin(sample_angle(i))], ...
            'r--','linewidth',line_thickness);
        
        % Plot cosine
       P.cosPlot(i)= plot(-y_bound+(2*y_bound).*[1:i]./T,...
            y_for_cosine_graph+graph_scalar*cos(sample_angle(1:i)),...
            'b--','linewidth',trig_line_thickness);
        
        % Plot sine
        P.sinPlot(i)=plot(-y_bound+(2*y_bound).*[1:i]./T,...
            y_for_sine_graph+graph_scalar*sin(sample_angle(1:i)),...
            'r--','linewidth',trig_line_thickness);
        
        pause(pause_time)
        if i<n_all_angles
            % delete rather than fill
%             delete(P.cc,P.pc); % can't delete more than one at a time
            delete(P.cc);
            delete(P.pc);
            delete(P.ccp);
            delete(P.cuc);
            delete(P.c2h);
            delete(P.c2v); 
            delete(P.hm);
            delete(P.vm);
        elseif i==n_all_angles
            delete(P.sinPlot(1:n_all_angles));
            delete(P.cosPlot(1:n_all_angles));           
        end
        
    end % for i=1:n_all_angles
    display_time(dp)=toc; % stop timer and assign to display_time(dp)
    
end % for dp=1:n_displays
display_time

