/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal;

import com.ur.polyscope.robot.configuration.FactoryPresetLimits;
import com.ur.polyscope.robot.configuration.PresetChecksum;
import com.ur.polyscope.robot.configuration.RobotChecksum;
import com.ur.polyscope.robot.configuration.internal.ChecksumSafetyVersion;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRobotChecksum
implements RobotChecksum {
    private Map<String, PresetChecksum> presetChecksumMap = new HashMap<String, PresetChecksum>();

    protected AbstractRobotChecksum(Map<ChecksumSafetyVersion, PresetChecksum> checksums) {
        for (Map.Entry<ChecksumSafetyVersion, PresetChecksum> entry : checksums.entrySet()) {
            this.putToPresetChecksumMap(entry.getKey(), entry.getValue());
        }
    }

    protected void putToPresetChecksumMap(ChecksumSafetyVersion safetyVersion, PresetChecksum presetChecksum) {
        this.presetChecksumMap.put(safetyVersion.toString(), presetChecksum);
    }

    public String getPreset(FactoryPresetLimits factoryPresetLimits, int majorSafetyVersion, int minorSafetyVersion) {
        PresetChecksum presetChecksum = this.presetChecksumMap.get(this.getKey(majorSafetyVersion, minorSafetyVersion));
        if (presetChecksum != null) {
            return presetChecksum.getPresetChecksum(factoryPresetLimits);
        }
        throw new IllegalArgumentException("Enum " + factoryPresetLimits + " not found for safety version " + majorSafetyVersion + "." + minorSafetyVersion);
    }

    public String getPreset(FactoryPresetLimits factoryPresetLimits, ChecksumSafetyVersion safetyVersion) {
        return this.getPreset(factoryPresetLimits, safetyVersion.getMajorVersion(), safetyVersion.getMinorVersion());
    }

    protected String getKey(int majorSafetyVersion, int minorSafetyVersion) {
        return new ChecksumSafetyVersion(majorSafetyVersion, minorSafetyVersion).toString();
    }

    public String getDefaultPreset_1_0() {
        return this.getPreset(FactoryPresetLimits.DEFAULT, ChecksumSafetyVersion.VERSION_1_0);
    }

    public String getFullSpeedPreset_1_0() {
        return this.getPreset(FactoryPresetLimits.FULL_SPEED, ChecksumSafetyVersion.VERSION_1_0);
    }

    public String getLowSpeedPreset_1_0() {
        return this.getPreset(FactoryPresetLimits.LOW_SPEED, ChecksumSafetyVersion.VERSION_1_0);
    }

    public String getVerySafePreset_1_0() {
        return this.getPreset(FactoryPresetLimits.VERY_SAFE, ChecksumSafetyVersion.VERSION_1_0);
    }

    public String getDefaultPreset_3_2() {
        return this.getPreset(FactoryPresetLimits.DEFAULT, ChecksumSafetyVersion.VERSION_3_2);
    }

    public String getFullSpeedPreset_3_2() {
        return this.getPreset(FactoryPresetLimits.FULL_SPEED, ChecksumSafetyVersion.VERSION_3_2);
    }

    public String getLowSpeedPreset_3_2() {
        return this.getPreset(FactoryPresetLimits.LOW_SPEED, ChecksumSafetyVersion.VERSION_3_2);
    }

    public String getVerySafePreset_3_2() {
        return this.getPreset(FactoryPresetLimits.VERY_SAFE, ChecksumSafetyVersion.VERSION_3_2);
    }

    public String getDefaultPreset_5_0() {
        return this.getPreset(FactoryPresetLimits.DEFAULT, ChecksumSafetyVersion.VERSION_5_0);
    }

    public String getFullSpeedPreset_5_0() {
        return this.getPreset(FactoryPresetLimits.FULL_SPEED, ChecksumSafetyVersion.VERSION_5_0);
    }

    public String getLowSpeedPreset_5_0() {
        return this.getPreset(FactoryPresetLimits.LOW_SPEED, ChecksumSafetyVersion.VERSION_5_0);
    }

    public String getVerySafePreset_5_0() {
        return this.getPreset(FactoryPresetLimits.VERY_SAFE, ChecksumSafetyVersion.VERSION_5_0);
    }

    public String getDefaultPreset_5_2() {
        return this.getPreset(FactoryPresetLimits.DEFAULT, ChecksumSafetyVersion.VERSION_5_2);
    }

    public String getFullSpeedPreset_5_2() {
        return this.getPreset(FactoryPresetLimits.FULL_SPEED, ChecksumSafetyVersion.VERSION_5_2);
    }

    public String getLowSpeedPreset_5_2() {
        return this.getPreset(FactoryPresetLimits.LOW_SPEED, ChecksumSafetyVersion.VERSION_5_2);
    }

    public String getVerySafePreset_5_2() {
        return this.getPreset(FactoryPresetLimits.VERY_SAFE, ChecksumSafetyVersion.VERSION_5_2);
    }
}

