/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal;

import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.view.constants.dev.ToolOutputMode;

public abstract class AbstractRobotTool
implements RobotTool {
    private final ForceValue forceValue;
    private final int maxCurrent;
    private final double maxAngle;
    private final boolean jointPositionInstallationValidity;
    private final boolean isInfiniteRevolutionsWrist3Allowed;

    protected AbstractRobotTool(ForceValue forceValue, int maximumCurrent, double maxAngle, boolean jointPositionInstallationValidity, boolean isInfiniteRevolutionsWrist3Allowed) {
        this.forceValue = forceValue;
        this.maxCurrent = maximumCurrent;
        this.maxAngle = maxAngle;
        this.jointPositionInstallationValidity = jointPositionInstallationValidity;
        this.isInfiniteRevolutionsWrist3Allowed = isInfiniteRevolutionsWrist3Allowed;
    }

    protected AbstractRobotTool(ForceValue forceValue, double maxAngle, boolean jointPositionInstallationValidity, boolean isInfiniteRevolutionsWrist3Allowed) {
        this.forceValue = forceValue;
        this.maxAngle = maxAngle;
        this.jointPositionInstallationValidity = jointPositionInstallationValidity;
        this.isInfiniteRevolutionsWrist3Allowed = isInfiniteRevolutionsWrist3Allowed;
        this.maxCurrent = -1;
    }

    public double getMinimumForceValue() {
        return this.forceValue.getMinimumForceValue();
    }

    public double getMaximumForceValue() {
        return this.forceValue.getMaximumForceValue();
    }

    public boolean jointPositionInstallationValidity() {
        return this.jointPositionInstallationValidity;
    }

    public boolean isInfiniteRevolutionsWrist3Allowed() {
        return this.isInfiniteRevolutionsWrist3Allowed;
    }

    public int getMaximumCurrent(ToolOutputMode toolOutputMode) {
        return this.maxCurrent;
    }

    public double getMaxAngle() {
        return this.maxAngle;
    }

    public static class ForceValue {
        private final double minimumForceValue;
        private final double maximumForceValue;

        public ForceValue(double minimumForceValue, double maximumForceValue) {
            this.minimumForceValue = minimumForceValue;
            this.maximumForceValue = maximumForceValue;
        }

        public double getMinimumForceValue() {
            return this.minimumForceValue;
        }

        public double getMaximumForceValue() {
            return this.maximumForceValue;
        }
    }
}

