/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal;

import com.google.inject.Provider;
import com.ur.polyscope.robot.configuration.RobotBundleRemover;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RobotBundleRemoverImpl
implements RobotBundleRemover {
    private final Provider<RobotIdentification> robotIdentificationProvider;

    @Inject
    public RobotBundleRemoverImpl(Provider<RobotIdentification> robotIdentificationProvider) {
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    public void deleteIrrelevantHelp(BundleContext context) {
        RobotType robotType = this.getRobotType();
        if (robotType != RobotType.UNDEFINED) {
            this.deleteHelp(robotType.name(), context);
        }
    }

    private RobotType getRobotType() {
        return RobotType.byId((int)((RobotIdentification)this.robotIdentificationProvider.get()).getRobotTypeId().getRobotTypeId());
    }

    private void deleteHelp(String robotType, BundleContext context) {
        for (Bundle bundle : context.getBundles()) {
            if (!this.isHelpBundle(bundle) || this.isRobotTypeInBundleName(robotType, bundle)) continue;
            this.removeBundle(bundle);
            this.deleteBundle(bundle);
        }
    }

    private void removeBundle(@NotNull Bundle bundle) {
        try {
            Log.info((String)("Removing bundle :" + bundle.getSymbolicName()));
            bundle.uninstall();
        }
        catch (Exception e) {
            Log.error((String)("Error occurred while removing bundle " + bundle.getSymbolicName()), (Throwable)e);
        }
    }

    private void deleteBundle(@NotNull Bundle bundle) {
        try {
            Log.info((String)("Deleting bundle :" + bundle.getSymbolicName()));
            String bundlePath = this.getFilePath(this.getBundleLocation(bundle));
            this.deleteFile(bundlePath);
        }
        catch (Exception e) {
            Log.error((String)("Error occurred while deleting bundle " + bundle.getSymbolicName()), (Throwable)e);
        }
    }

    private boolean isHelpBundle(@NotNull Bundle bundle) {
        if (bundle.getSymbolicName() != null) {
            return bundle.getSymbolicName().startsWith("com.ur.polyscope.help-g3") || bundle.getSymbolicName().startsWith("com.ur.polyscope.help-g5");
        }
        return false;
    }

    private boolean isRobotTypeInBundleName(String robotType, Bundle bundle) {
        if (bundle.getSymbolicName() != null) {
            return bundle.getSymbolicName().contains(robotType);
        }
        return false;
    }

    private String getBundleLocation(Bundle bundle) {
        return bundle.getLocation().replace("reference:", "");
    }

    private String getFilePath(String bundleLocation) throws MalformedURLException {
        return new URL(bundleLocation).getFile();
    }

    void deleteFile(String path) {
        new File(path).delete();
    }
}

