/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal;

import com.ur.polyscope.robot.configuration.RobotBundleRemover;
import com.ur.polyscope.robot.configuration.RobotChecksum;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotDh;
import com.ur.polyscope.robot.configuration.RobotDraw3D;
import com.ur.polyscope.robot.configuration.RobotID;
import com.ur.polyscope.robot.configuration.RobotInstallationInit;
import com.ur.polyscope.robot.configuration.RobotJointCurrent;
import com.ur.polyscope.robot.configuration.RobotPayload;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.robot.configuration.contribution.RobotTypeSupport;
import com.ur.polyscope.robot.configuration.internal.RobotTypeSubTypeSupport;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RobotConfigurationProviderImpl
implements RobotConfigurationProvider {
    private RobotChecksum robotChecksum = null;
    private RobotInstallationInit robotInstallationInit = null;
    private RobotPayload robotPayload = null;
    private RobotTool robotTool = null;
    private RobotBundleRemover robotBundleRemover = null;
    private RobotDh robotDh = null;
    private RobotID robotID = null;
    private RobotDraw3D robotDraw3D = null;
    private RobotJointCurrent robotJointCurrent = null;
    private final RobotType robotType;
    private final int robotSubType;

    public RobotChecksum getRobotChecksum() {
        return this.robotChecksum;
    }

    public RobotDh getRobotDh() {
        return this.robotDh;
    }

    public RobotInstallationInit getRobotInstallationInit() {
        return this.robotInstallationInit;
    }

    public RobotPayload getRobotPayload() {
        return this.robotPayload;
    }

    public RobotTool getRobotTool() {
        return this.robotTool;
    }

    public RobotBundleRemover getRobotBundleRemover() {
        return this.robotBundleRemover;
    }

    public RobotID getRobotID() {
        return this.robotID;
    }

    public RobotDraw3D getRobotDraw3D() {
        return this.robotDraw3D;
    }

    public RobotJointCurrent getRobotJointCurrent() {
        return this.robotJointCurrent;
    }

    @Inject
    RobotConfigurationProviderImpl(RobotTypeIdentificationProvider robotIdentificationProvider, RobotBundleRemover robotHelp, Set<RobotChecksum> robotChecksums, Set<RobotDh> robotDhs, Set<RobotDraw3D> robotDraws, Set<RobotID> robotIDs, Set<RobotInstallationInit> robotInits, Set<RobotJointCurrent> robotJoints, Set<RobotPayload> robotPayloads, Set<RobotTool> robotTools) {
        this.robotType = robotIdentificationProvider.getRobotTypeIdentification().robotType();
        this.robotSubType = robotIdentificationProvider.getRobotTypeIdentification().robotSubType();
        this.setRobotBundleRemover(robotHelp);
        this.setRobotChecksum(robotChecksums);
        this.setRobotDh(robotDhs);
        this.setRobotDraw3D(robotDraws);
        this.setRobotID(robotIDs);
        this.setRobotInstallationInit(robotInits);
        this.setRobotJointCurrent(robotJoints);
        this.setRobotPayload(robotPayloads);
        this.setRobotTool(robotTools);
    }

    private void setRobotBundleRemover(RobotBundleRemover robotHelp) {
        this.robotBundleRemover = robotHelp;
        if (this.robotBundleRemover == null) {
            throw new IllegalStateException("Could not find robot safety implementation");
        }
    }

    private boolean supportsRobotType(Object o) {
        if (o instanceof RobotTypeSubTypeSupport) {
            return ((RobotTypeSubTypeSupport)o).supportsRobotType(this.robotType.getId(), this.robotSubType);
        }
        if (o instanceof RobotTypeSupport) {
            return ((RobotTypeSupport)o).supportsRobotType(this.robotType.getId());
        }
        return false;
    }

    private void setRobotChecksum(Set<RobotChecksum> robotChecksums) {
        for (RobotChecksum rc : robotChecksums) {
            if (!this.supportsRobotType(rc)) continue;
            this.robotChecksum = rc;
            break;
        }
        if (this.robotChecksum == null) {
            throw new IllegalStateException("Could not find robot safety implementation for " + this.robotType + " " + this.robotSubType);
        }
    }

    private void setRobotDh(Set<RobotDh> robotDhs) {
        for (RobotDh rd : robotDhs) {
            if (!this.supportsRobotType(rd)) continue;
            this.robotDh = rd;
            break;
        }
        if (this.robotDh == null) {
            throw new IllegalStateException("Could not find robot DH implementation" + this.robotType + " " + this.robotSubType);
        }
    }

    private void setRobotDraw3D(Set<RobotDraw3D> robotDraws) {
        for (RobotDraw3D rd3 : robotDraws) {
            if (!this.supportsRobotType(rd3)) continue;
            this.robotDraw3D = rd3;
            break;
        }
        if (this.robotDraw3D == null) {
            throw new IllegalStateException("Could not find robot tool implementation for " + this.robotType + " " + this.robotSubType);
        }
    }

    private void setRobotID(Set<RobotID> robotIDs) {
        for (RobotID ri : robotIDs) {
            if (!this.supportsRobotType(ri)) continue;
            this.robotID = ri;
            break;
        }
        if (this.robotID == null) {
            throw new IllegalStateException("Could not find robot ID implementation " + this.robotType + " " + this.robotSubType);
        }
    }

    private void setRobotInstallationInit(Set<RobotInstallationInit> robotInits) {
        for (RobotInstallationInit ri : robotInits) {
            if (!this.supportsRobotType(ri)) continue;
            this.robotInstallationInit = ri;
            break;
        }
        if (this.robotInstallationInit == null) {
            throw new IllegalStateException("Could not find robot initialization implementation for " + this.robotType + " " + this.robotSubType);
        }
    }

    private void setRobotJointCurrent(Set<RobotJointCurrent> robotJoints) {
        for (RobotJointCurrent rj : robotJoints) {
            if (!this.supportsRobotType(rj)) continue;
            this.robotJointCurrent = rj;
            break;
        }
        if (this.robotJointCurrent == null) {
            throw new IllegalStateException("Could not find robot joint current implementation");
        }
    }

    private void setRobotPayload(Set<RobotPayload> robotPayloads) {
        for (RobotPayload rp : robotPayloads) {
            if (!this.supportsRobotType(rp)) continue;
            this.robotPayload = rp;
            break;
        }
        if (this.robotPayload == null) {
            throw new IllegalStateException("Could not find robot payload implementation for " + this.robotType + " " + this.robotSubType);
        }
    }

    private void setRobotTool(Set<RobotTool> robotTools) {
        for (RobotTool rt : robotTools) {
            if (!this.supportsRobotType(rt)) continue;
            this.robotTool = rt;
            break;
        }
        if (this.robotTool == null) {
            throw new IllegalStateException("Could not find robot tool implementation for " + this.robotType + " " + this.robotSubType);
        }
    }
}

