/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.controller;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.robot.configuration.internal.joint.JointConfigurationModelSource;
import com.ur.polyscope.robot.configuration.internal.kinematics.DHParametersModelSource;
import com.ur.polyscope.robot.configuration.internal.tool.ToolConfigurationModelSource;
import com.ur.view.constants.comm.RobotStatePackageType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConfigurationDataPackageConsumer
implements RobotStatePackageConsumer,
ConfigurationState {
    private final Object sync = new Object();
    private ToolConfigurationModelSource toolConfigurationModelSource;
    private JointConfigurationModelSource jointConfigurationModelSource;
    private DHParametersModelSource dhParametersModelSource;
    private boolean configurationDataReceived;
    private static final Logger LOG = LogFactory.createLogger(ConfigurationDataPackageConsumer.class);

    @Inject
    public ConfigurationDataPackageConsumer(ToolConfigurationModelSource toolConfigurationModelSource, JointConfigurationModelSource jointConfigurationModelSource, DHParametersModelSource dhParametersModelSource) {
        this.toolConfigurationModelSource = toolConfigurationModelSource;
        this.jointConfigurationModelSource = jointConfigurationModelSource;
        this.dhParametersModelSource = dhParametersModelSource;
    }

    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.CONFIGURATION_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consume(DataInput stream, int messageLength) throws IOException {
        int messageOffset = 0;
        Object object = this.sync;
        synchronized (object) {
            int i;
            double[] jointMinLimit = new double[6];
            double[] jointMaxLimit = new double[6];
            double[] jointMaxSpeed = new double[6];
            double[] jointMaxAccel = new double[6];
            for (i = 0; i < 6; ++i) {
                jointMinLimit[i] = stream.readDouble();
                jointMaxLimit[i] = stream.readDouble();
            }
            messageOffset += 96;
            for (i = 0; i < 6; ++i) {
                jointMaxSpeed[i] = stream.readDouble();
                jointMaxAccel[i] = stream.readDouble();
            }
            messageOffset += 96;
            double vJointDefault = stream.readDouble();
            double aJointDefault = stream.readDouble();
            messageOffset += 16;
            double vToolDefault = stream.readDouble();
            double aToolDefault = stream.readDouble();
            double eqradius = stream.readDouble();
            messageOffset += 24;
            double[] dhA = ConfigurationDataPackageConsumer.read6Doubles(stream);
            double[] dhD = ConfigurationDataPackageConsumer.read6Doubles(stream);
            double[] dhAlpha = ConfigurationDataPackageConsumer.read6Doubles(stream);
            stream.skipBytes(48);
            messageOffset += 192;
            stream.skipBytes(8);
            stream.readInt();
            stream.skipBytes(4);
            messageOffset += 16;
            this.toolConfigurationModelSource.emit(vToolDefault, aToolDefault, eqradius);
            this.jointConfigurationModelSource.emit(jointMinLimit, jointMaxLimit, jointMaxSpeed, jointMaxAccel, vJointDefault, aJointDefault);
            this.dhParametersModelSource.emit(dhA, dhD, dhAlpha);
            this.configurationDataReceived = true;
        }
        LOG.info("Received Configuration Data from Controller", new Object[0]);
        return messageOffset;
    }

    public boolean configurationDataNotReceivedFromController() {
        return !this.configurationDataReceived;
    }

    private static double[] read6Doubles(DataInput stream) throws IOException {
        double[] result = new double[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = stream.readDouble();
        }
        return result;
    }

    public void initialize(RobotState robotStateToEditHere) {
    }
}

