/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.joint;

import com.ur.monitor.StreamedModel;
import com.ur.monitor.model.JointType;
import com.ur.util.Synchronized;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class JointConfiguration
implements StreamedModel {
    private final double[] jointMinLimit = new double[6];
    private final double[] jointMaxLimit = new double[6];
    private final double[] jointMaxSpeed = new double[6];
    private final double[] jointMaxAccel = new double[6];
    private final double vJointDefault;
    private final double aJointDefault;
    private final Object sync = new Object();

    JointConfiguration(double[] jointMinLimit, double[] jointMaxLimit, double[] jointMaxSpeed, double[] jointMaxAccel, double vJointDefault, double aJointDefault) {
        System.arraycopy(jointMinLimit, 0, this.jointMinLimit, 0, 6);
        System.arraycopy(jointMaxLimit, 0, this.jointMaxLimit, 0, 6);
        System.arraycopy(jointMaxSpeed, 0, this.jointMaxSpeed, 0, 6);
        System.arraycopy(jointMaxAccel, 0, this.jointMaxAccel, 0, 6);
        this.vJointDefault = vJointDefault;
        this.aJointDefault = aJointDefault;
    }

    double[] getJointMinLimit() {
        return (double[])Synchronized.copyOf((Object)this.sync, (Object)this.jointMinLimit);
    }

    double[] getJointMaxLimit() {
        return (double[])Synchronized.copyOf((Object)this.sync, (Object)this.jointMaxLimit);
    }

    double[] getJointMaxSpeed() {
        return (double[])Synchronized.copyOf((Object)this.sync, (Object)this.jointMaxSpeed);
    }

    double[] getJointMaxAccel() {
        return (double[])Synchronized.copyOf((Object)this.sync, (Object)this.jointMaxAccel);
    }

    double getvJointDefault() {
        return (Double)Synchronized.copyOf((Object)this.sync, (Object)this.vJointDefault);
    }

    double getaJointDefault() {
        return (Double)Synchronized.copyOf((Object)this.sync, (Object)this.aJointDefault);
    }

    double getMaximumJointLimit(JointType jointType) {
        return this.jointMaxLimit[jointType.getJointNumber()];
    }

    double getMinimumJointLimit(JointType jointType) {
        return this.jointMinLimit[jointType.getJointNumber()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JointConfiguration that = (JointConfiguration)o;
        return new EqualsBuilder().append(this.vJointDefault, that.vJointDefault).append(this.aJointDefault, that.aJointDefault).append(this.jointMinLimit, that.jointMinLimit).append(this.jointMaxLimit, that.jointMaxLimit).append(this.jointMaxSpeed, that.jointMaxSpeed).append(this.jointMaxAccel, that.jointMaxAccel).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.jointMinLimit).append(this.jointMaxLimit).append(this.jointMaxSpeed).append(this.jointMaxAccel).append(this.vJointDefault).append(this.aJointDefault).toHashCode();
    }
}

