/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.joint;

import com.ur.polyscope.robot.configuration.internal.RobotTypeContribution;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationProvider;
import com.ur.view.constants.dev.robotsize.JointSize;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;

public class JointConfigurationProviderImpl
implements JointConfigurationProvider {
    private static final JointSize[] JOINT_SIZES_UR3 = new JointSize[]{JointSize.SIZE2, JointSize.SIZE2, JointSize.SIZE1, JointSize.SIZE0, JointSize.SIZE0, JointSize.SIZE0};
    private static final JointSize[] JOINT_SIZES_UR5 = new JointSize[]{JointSize.SIZE3, JointSize.SIZE3, JointSize.SIZE3, JointSize.SIZE1, JointSize.SIZE1, JointSize.SIZE1};
    private static final JointSize[] JOINT_SIZES_UR10 = new JointSize[]{JointSize.SIZE4, JointSize.SIZE4, JointSize.SIZE3, JointSize.SIZE2, JointSize.SIZE2, JointSize.SIZE2};
    private static final JointSize[] JOINT_SIZES_UR16 = new JointSize[]{JointSize.SIZE4, JointSize.SIZE4, JointSize.SIZE3, JointSize.SIZE2, JointSize.SIZE2, JointSize.SIZE2};
    private final RobotTypeIdentificationProvider robotIdentificationProvider;
    private final Set<RobotTypeContribution> robotTypeContributions;

    @Inject
    public JointConfigurationProviderImpl(RobotTypeIdentificationProvider robotIdentificationProvider, Set<RobotTypeContribution> robotTypeContributions) {
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.robotTypeContributions = robotTypeContributions;
    }

    public String[] getJointIds() {
        JointSize[] jointSizes;
        RobotType robotType = this.robotIdentificationProvider.getRobotTypeIdentification().robotType();
        switch (robotType) {
            case UR3: {
                jointSizes = JOINT_SIZES_UR3;
                break;
            }
            case UR5: {
                jointSizes = JOINT_SIZES_UR5;
                break;
            }
            case UR10: {
                jointSizes = JOINT_SIZES_UR10;
                break;
            }
            case UR16: {
                jointSizes = JOINT_SIZES_UR16;
                break;
            }
            default: {
                jointSizes = this.getJointSizesFromContribution(robotType);
            }
        }
        if (jointSizes == null) {
            throw new UnsupportedOperationException("Got unsupported robot type: " + robotType);
        }
        String[] result = new String[jointSizes.length];
        for (int i = 0; i < jointSizes.length; ++i) {
            result[i] = String.valueOf(jointSizes[i].getId());
        }
        return result;
    }

    public File getFirmwareFilePath(File firmwareDir, int joint) {
        RobotType rt = this.robotIdentificationProvider.getRobotTypeIdentification().robotType();
        if (rt == RobotType.UNDEFINED) {
            return null;
        }
        String robotTypeName = rt.toString();
        return new File(firmwareDir.getAbsolutePath() + "/joint/" + robotTypeName + "/joint_" + joint + "_" + robotTypeName.toLowerCase() + "_fw.elf.S");
    }

    private JointSize[] getJointSizesFromContribution(RobotType robotType) {
        JointSize[] jointSizes = null;
        for (RobotTypeContribution contributedType : this.robotTypeContributions) {
            if (!contributedType.supportsRobotType(robotType.getId())) continue;
            int[] jointIdsForRobotType = contributedType.getJointIdsForRobotType();
            jointSizes = new JointSize[jointIdsForRobotType.length];
            for (int i = 0; i < jointIdsForRobotType.length; ++i) {
                int id = jointIdsForRobotType[i];
                jointSizes[i] = JointSize.byId((int)id);
            }
        }
        return jointSizes;
    }
}

