/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.joint;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotInstallationInit;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.robot.configuration.internal.joint.JointConfiguration;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointTolerances;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JointConfigurationSettingsImpl
implements JointConfigurationSettings {
    private final JointTolerances jointTolerances;
    private RobotTool robotTool;
    private RobotInstallationInit robotInstallationInit;
    private JointConfiguration jointConfiguration = new JointConfiguration(new double[6], new double[6], new double[6], new double[6], 0.0, 0.0);
    private boolean configurationDataReceived = false;
    private boolean dataReceivedCheckAlreadyPerformed;
    private static final Logger LOG = LogFactory.createLogger(JointConfigurationSettings.class);

    @Inject
    public JointConfigurationSettingsImpl(RobotConfigurationProvider robot, JointTolerances jointTolerances, @Source(value=JointConfiguration.class) Recipe<JointConfiguration> jointConfigurationRecipe) {
        this.robotTool = robot.getRobotTool();
        this.robotInstallationInit = robot.getRobotInstallationInit();
        this.jointTolerances = jointTolerances;
        this.setInitialValues();
        jointConfigurationRecipe.subscribe((Consumer)new Consumer<JointConfiguration>(){

            public void accept(JointConfiguration jointConfiguration) {
                JointConfigurationSettingsImpl.this.jointConfiguration = jointConfiguration;
                JointConfigurationSettingsImpl.this.configurationDataReceived = true;
            }
        });
    }

    public double getMaximumJointLimit(JointType jointType) {
        this.checkIfDataFromControllerReceived("joint_max_limit_for_jointType");
        return this.jointConfiguration.getMaximumJointLimit(jointType);
    }

    public double getMinimumJointLimit(JointType jointType) {
        this.checkIfDataFromControllerReceived("joint_min_limit_for_jointType");
        return this.jointConfiguration.getMinimumJointLimit(jointType);
    }

    public double[] getJointMinLimit() {
        this.checkIfDataFromControllerReceived("joint_min_limit");
        return this.jointConfiguration.getJointMinLimit();
    }

    public double[] getJointMaxLimit() {
        this.checkIfDataFromControllerReceived("joint_max_limit");
        return this.jointConfiguration.getJointMaxLimit();
    }

    public double[] getJointMaxSpeed() {
        this.checkIfDataFromControllerReceived("joint_max_speed");
        return this.jointConfiguration.getJointMaxSpeed();
    }

    public double[] getJointMaxAcceleration() {
        this.checkIfDataFromControllerReceived("joint_max_accel");
        return this.jointConfiguration.getJointMaxAccel();
    }

    public double getVJointDefault() {
        this.checkIfDataFromControllerReceived("v_joint_default");
        return this.jointConfiguration.getvJointDefault();
    }

    public double getAJointDefault() {
        this.checkIfDataFromControllerReceived("a_joint_default");
        return this.jointConfiguration.getaJointDefault();
    }

    public double[] getJointMaxSpeedWithoutTolerances() {
        this.checkIfDataFromControllerReceived("joint_max_speed");
        double[] jointMaxSpeedWithoutTolerances = new double[6];
        double[] jointSpeedTolerances = this.jointTolerances.getJointSpeedTolerances();
        double[] jointMaxSpeed = this.jointConfiguration.getJointMaxSpeed();
        for (int i = 0; i < 6; ++i) {
            jointMaxSpeedWithoutTolerances[i] = jointMaxSpeed[i] - jointSpeedTolerances[i];
        }
        return jointMaxSpeedWithoutTolerances;
    }

    public boolean infiniteRevolutionsForWrist3() {
        return this.robotTool.isInfiniteRevolutionsWrist3Allowed();
    }

    private void setInitialValues() {
        double[] jointMinLimit = this.robotInstallationInit.getNoDefaultInstallationFileMinJointPosition();
        double[] jointMaxLimit = this.robotInstallationInit.getNoDefaultInstallationFileMaxJointPosition();
        double[] jointMaxSpeed = this.robotInstallationInit.getNoDefaultInstallationFileMaxJointSpeed();
        double[] jointMaxAccel = this.robotInstallationInit.getNoDefaultInstallationFileMaxJointAcceleration();
        double vJointDefault = this.robotInstallationInit.getVJointDefault();
        double aJointDefault = this.robotInstallationInit.getAJointDefault();
        this.jointConfiguration = new JointConfiguration(jointMinLimit, jointMaxLimit, jointMaxSpeed, jointMaxAccel, vJointDefault, aJointDefault);
    }

    private void checkIfDataFromControllerReceived(Object dataToLookup) {
        if (!this.configurationDataReceived && !this.dataReceivedCheckAlreadyPerformed) {
            this.dataReceivedCheckAlreadyPerformed = true;
            LOG.warn("Method used before correct value has been received from controller, returning default = " + dataToLookup, new Object[0]);
            LOG.warn("Ignoring any future reports of error", new Object[0]);
        }
    }
}

