/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.kinematics;

import com.ur.polyscope.robot.configuration.kinematics.DH;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class DHImpl
implements DH {
    private final double a;
    private final double d;
    private final double alpha;
    private final double theta;
    private final double cosAlpha;
    private final double sinAlpha;
    private final Matrix3d r = new Matrix3d();
    private final Vector3d p = new Vector3d();

    DHImpl(double a, double d, double alpha, double theta) {
        this.a = a;
        this.d = d;
        this.alpha = alpha;
        this.theta = theta;
        this.cosAlpha = Math.cos(alpha);
        this.sinAlpha = Math.sin(alpha);
    }

    public void applyCoordinateTransformation(Transform3D transform, double theta) {
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        this.updateR(cosTheta, sinTheta);
        this.updateP(cosTheta, sinTheta);
        transform.setRotation(this.r);
        transform.setTranslation(this.p);
    }

    public double getA() {
        return this.a;
    }

    public double getD() {
        return this.d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getCosAlpha() {
        return this.cosAlpha;
    }

    public double getSinAlpha() {
        return this.sinAlpha;
    }

    private void updateR(double cosTheta, double sinTheta) {
        this.r.m00 = cosTheta;
        this.r.m01 = -sinTheta * this.cosAlpha;
        this.r.m02 = sinTheta * this.sinAlpha;
        this.r.m10 = sinTheta;
        this.r.m11 = cosTheta * this.cosAlpha;
        this.r.m12 = -cosTheta * this.sinAlpha;
        this.r.m20 = 0.0;
        this.r.m21 = this.sinAlpha;
        this.r.m22 = this.cosAlpha;
    }

    private void updateP(double cosTheta, double sinTheta) {
        this.p.x = this.a * cosTheta;
        this.p.y = this.a * sinTheta;
        this.p.z = this.d;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DHImpl dh = (DHImpl)o;
        return Double.compare(dh.a, this.a) == 0 && Double.compare(dh.d, this.d) == 0 && Double.compare(dh.alpha, this.alpha) == 0 && Double.compare(dh.theta, this.theta) == 0;
    }

    public int hashCode() {
        int result = Double.valueOf(this.a).hashCode();
        result = 31 * result + Double.valueOf(this.d).hashCode();
        result = 31 * result + Double.valueOf(this.alpha).hashCode();
        result = 31 * result + Double.valueOf(this.theta).hashCode();
        return result;
    }
}

