/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.kinematics;

import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.internal.kinematics.DHImpl;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.polyscope.robot.configuration.kinematics.DHParameters;
import java.util.Arrays;

public class DHParametersImpl
implements DHParameters {
    private final DH[] parameters;
    private final double[] a;
    private final double[] d;
    private final double[] alpha;
    private final double[] theta;

    DHParametersImpl(double[] dhA, double[] dhD, double[] dhAlpha) {
        this(dhA, dhD, dhAlpha, new double[6]);
    }

    DHParametersImpl(double[] dhA, double[] dhD, double[] dhAlpha, double[] dhTheta) {
        this.a = dhA;
        this.d = dhD;
        this.alpha = dhAlpha;
        this.theta = dhTheta;
        this.parameters = new DHImpl[JointType.values().length];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = new DHImpl(dhA[i], dhD[i], dhAlpha[i], dhTheta[i]);
        }
    }

    public DH joint(int i) {
        return this.parameters[i];
    }

    public double[] a() {
        return (double[])this.a.clone();
    }

    public double[] d() {
        return (double[])this.d.clone();
    }

    public double[] alpha() {
        return (double[])this.alpha.clone();
    }

    public double[] theta() {
        return (double[])this.theta.clone();
    }

    public String toString() {
        return "delta theta: " + Arrays.toString(this.theta) + "\na: " + Arrays.toString(this.a) + "\nd: " + Arrays.toString(this.d) + "\nalpha: " + Arrays.toString(this.alpha) + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DHParametersImpl that = (DHParametersImpl)o;
        boolean paramsEq = Arrays.equals(this.parameters, that.parameters);
        boolean aEq = Arrays.equals(this.a, that.a);
        boolean dEq = Arrays.equals(this.d, that.d);
        boolean alphaEq = Arrays.equals(this.alpha, that.alpha);
        boolean thetaEq = Arrays.equals(this.theta, that.theta);
        boolean valuesEq = aEq && dEq && alphaEq && thetaEq;
        return paramsEq && valuesEq;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.parameters);
        result = 31 * result + Arrays.hashCode(this.a);
        result = 31 * result + Arrays.hashCode(this.d);
        result = 31 * result + Arrays.hashCode(this.alpha);
        result = 31 * result + Arrays.hashCode(this.theta);
        return result;
    }
}

