/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.kinematics;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.internal.kinematics.DHParametersImpl;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.polyscope.robot.configuration.kinematics.DHParameters;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.CalibrationStatus;
import com.ur.view.constants.dev.RobotMode;
import java.util.Arrays;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;

public class KinematicsCalibrationImpl
implements KinematicsCalibration {
    private final DHParameters dhParameters;
    private int[] jointChecksum;
    private CalibrationStatus status;
    private boolean validChecksum;
    private transient int mergedChecksum = 0;
    private transient boolean validKinematics = true;

    KinematicsCalibrationImpl(double[] deltaTheta, double[] a, double[] d, double[] alpha, int[] jointChecksum, CalibrationStatus status, RobotMode robotMode) {
        this(deltaTheta, a, d, alpha, jointChecksum, status, KinematicsCalibrationImpl.isChecksumValid(robotMode, jointChecksum));
    }

    KinematicsCalibrationImpl(double[] deltaTheta, double[] a, double[] d, double[] alpha, int[] jointChecksum, CalibrationStatus status, boolean validChecksum) {
        this.dhParameters = new DHParametersImpl(a, d, alpha, deltaTheta);
        this.jointChecksum = jointChecksum;
        this.status = status;
        this.validChecksum = validChecksum;
    }

    public int[] getJointChecksum() {
        return this.jointChecksum;
    }

    public CalibrationStatus getStatus() {
        return this.status;
    }

    public boolean isValidChecksum() {
        return this.validChecksum;
    }

    public boolean isValidKinematics() {
        return this.validKinematics;
    }

    public void setValidKinematics(boolean validKinematics) {
        this.validKinematics = validKinematics;
    }

    public double[] getA() {
        return this.dhParameters.a();
    }

    public double[] getAlpha() {
        return this.dhParameters.alpha();
    }

    public double[] getD() {
        return this.dhParameters.d();
    }

    public double[] getDeltaTheta() {
        return this.dhParameters.theta();
    }

    public KinematicsCalibration clone() {
        try {
            return (KinematicsCalibration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.error((String)"Could not clone Kinematics Calibration: ", (Throwable)e);
            return null;
        }
    }

    public Transform3D getBaseToEnd(JointPositionVector q) {
        Transform3D t = this.getTransform(q.getJoint(0), 0);
        double[] a = this.dhParameters.a();
        for (int i = 1; i < a.length; ++i) {
            t.mul(this.getTransform(q.getJoint(i), i));
        }
        return t;
    }

    public Transform3D getBaseToJoint(JointPositionVector q, JointType jointType) {
        Transform3D t = new Transform3D();
        for (int i = 0; i < jointType.getJointNumber(); ++i) {
            t.mul(this.getTransform(q.getJoint(i), i));
        }
        return t;
    }

    public String toString() {
        return this.dhParameters.toString();
    }

    public boolean checksumChanged(KinematicsCalibration other) {
        return other == null || !Arrays.equals(this.jointChecksum, other.getJointChecksum());
    }

    public boolean changedDHParameters(KinematicsCalibration other) {
        return !Arrays.equals(this.getA(), other.getA()) || !Arrays.equals(this.getD(), other.getD()) || !Arrays.equals(this.getAlpha(), other.getAlpha());
    }

    public boolean deltaThetaChanged(KinematicsCalibration other) {
        return !Arrays.equals(this.getDeltaTheta(), other.getDeltaTheta());
    }

    public int getMergedChecksumIfValid() {
        if (this.isValidKinematics()) {
            return this.getMergedChecksum();
        }
        return 0;
    }

    private Transform3D getTransform(double q, int index) {
        DH dh = this.dhParameters.joint(index);
        return new Transform3D(new Matrix4d(Math.cos(q + dh.getTheta()), -Math.sin(q + dh.getTheta()) * dh.getCosAlpha(), Math.sin(q + dh.getTheta()) * dh.getSinAlpha(), dh.getA() * Math.cos(q + dh.getTheta()), Math.sin(q + dh.getTheta()), Math.cos(q + dh.getTheta()) * dh.getCosAlpha(), -Math.cos(q + dh.getTheta()) * dh.getSinAlpha(), dh.getA() * Math.sin(q + dh.getTheta()), 0.0, dh.getSinAlpha(), dh.getCosAlpha(), dh.getD(), 0.0, 0.0, 0.0, 1.0));
    }

    public int getMergedChecksum() {
        if (this.mergedChecksum == 0) {
            this.mergedChecksum = this.calcChecksum(this.jointChecksum);
        }
        return this.mergedChecksum;
    }

    private int calcChecksum(int[] inputdata) {
        int result = 0;
        int crcPolynomial = -306674912;
        int[] nArray = inputdata;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int inputdatum;
            int data = inputdatum = nArray[i];
            for (int k = 0; k < 32; ++k) {
                result = (data >>> 31 ^ result >>> 31) > 0 ? result << 1 ^ crcPolynomial : (result <<= 1);
                data <<= 1;
            }
        }
        return result;
    }

    private static boolean isChecksumValid(RobotMode robotMode, int[] jointChecksum) {
        boolean valid = EqualsUtil.equalsOneOf((Object)robotMode, (Object[])new RobotMode[]{RobotMode.POWER_ON, RobotMode.IDLE, RobotMode.BACKDRIVE, RobotMode.RUNNING});
        for (int value : jointChecksum) {
            valid &= value != -1;
        }
        return valid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinematicsCalibrationImpl that = (KinematicsCalibrationImpl)o;
        return this.validChecksum == that.validChecksum && this.dhParameters.equals(that.dhParameters) && Arrays.equals(this.jointChecksum, that.jointChecksum) && this.status == that.status;
    }

    public int hashCode() {
        int result = this.dhParameters.hashCode();
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (this.validChecksum ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.jointChecksum);
        return result;
    }
}

