/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.kinematics;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.robot.configuration.internal.kinematics.KinematicCalibrationModelSource;
import com.ur.polyscope.robot.configuration.internal.kinematics.KinematicsCalibrationImpl;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.CalibrationStatus;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class KinematicsInfoPackageConsumer
implements RobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = 220;
    private RobotState robotState;
    private final KinematicCalibrationModelSource kinematicCalibrationModelSource;

    @Inject
    public KinematicsInfoPackageConsumer(KinematicCalibrationModelSource kinematicCalibrationModelSource) {
        this.kinematicCalibrationModelSource = kinematicCalibrationModelSource;
    }

    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.KINEMATICS_INFO;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        int x;
        int[] jointChecksum = new int[6];
        double[] deltaTheta = new double[6];
        double[] a = new double[6];
        double[] d = new double[6];
        double[] alpha = new double[6];
        for (x = 0; x < 6; ++x) {
            jointChecksum[x] = stream.readInt();
        }
        for (x = 0; x < 6; ++x) {
            deltaTheta[x] = stream.readDouble();
        }
        for (x = 0; x < 6; ++x) {
            a[x] = stream.readDouble();
        }
        for (x = 0; x < 6; ++x) {
            d[x] = stream.readDouble();
        }
        for (x = 0; x < 6; ++x) {
            alpha[x] = stream.readDouble();
        }
        int calibrationStatus = stream.readInt();
        KinematicsCalibrationImpl calibration = new KinematicsCalibrationImpl(deltaTheta, a, d, alpha, jointChecksum, CalibrationStatus.byId((int)calibrationStatus), this.robotState.robotMode);
        this.kinematicCalibrationModelSource.emit(calibration);
        return 220;
    }

    public void initialize(RobotState robotState) {
        this.robotState = robotState;
    }
}

