/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.optimove;

import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationSettings;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class OptiMoveConfigurationProviderImpl
implements OptiMoveConfigurationProvider {
    private final Set<OptiMoveConfigurationSettings> configurationSettings;
    private final RobotTypeIdentificationProvider robotTypeIdentificationProvider;

    @Inject
    public OptiMoveConfigurationProviderImpl(Set<OptiMoveConfigurationSettings> configurationSettings, RobotTypeIdentificationProvider robotTypeIdentificationProvider) {
        this.configurationSettings = configurationSettings;
        this.robotTypeIdentificationProvider = robotTypeIdentificationProvider;
    }

    public Optional<OptiMoveConfigurationSettings> getOptiMoveConfigurationSettings() {
        RobotTypeIdentifier robotIdentification = this.robotTypeIdentificationProvider.getRobotTypeIdentification().getRobotTypeId();
        for (OptiMoveConfigurationSettings configurationSetting : this.configurationSettings) {
            if (!configurationSetting.supportsRobotType(robotIdentification.getRobotTypeId())) continue;
            return Optional.of(configurationSetting);
        }
        return Optional.empty();
    }
}

