/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.payload;

import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorHelper {
    @Inject
    public PayloadAndCogWarningCalculatorHelper() {
    }

    public boolean isBelowWeightLimit(Weight mass, double maxWeightAllowed) {
        return mass.asDouble() <= maxWeightAllowed;
    }

    public boolean isBelowLengthLimit(Length cogDistance, double maxCogAllowed) {
        return cogDistance.asDouble() <= maxCogAllowed;
    }

    public boolean isBelowSlopedLimit(Weight mass, Length cogDistance, Point2d intersectionWithMaxWeight, Point2d intersectionWithMaxCog) {
        return this.doGradientCheck(mass, cogDistance, intersectionWithMaxWeight, intersectionWithMaxCog, true);
    }

    public boolean isBelowSlopedLimitNoPreCheck(Weight mass, Length cogDistance, Point2d intersectionWithMaxWeight, Point2d intersectionWithMaxCog) {
        return this.doGradientCheck(mass, cogDistance, intersectionWithMaxWeight, intersectionWithMaxCog, false);
    }

    private boolean doGradientCheck(Weight mass, Length cogDistance, Point2d intersectionWithMaxWeight, Point2d intersectionWithMaxCog, boolean performPreCheck) {
        if (performPreCheck && mass.asDouble() > intersectionWithMaxWeight.y) {
            return false;
        }
        if (performPreCheck && cogDistance.asDouble() > intersectionWithMaxCog.x) {
            return false;
        }
        double gradient = (intersectionWithMaxWeight.y - intersectionWithMaxCog.y) / (intersectionWithMaxWeight.x - intersectionWithMaxCog.x);
        double intersectionWithYAxis = intersectionWithMaxWeight.y - gradient * intersectionWithMaxWeight.x;
        return mass.asDouble() <= gradient * cogDistance.asDouble() + intersectionWithYAxis + 1.0E-4;
    }
}

