/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.payload;

import com.google.inject.Inject;
import com.ur.polyscope.robot.configuration.contribution.RobotTypeSupport;
import com.ur.polyscope.robot.configuration.internal.RobotTypeSubTypeSupport;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentification;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningProvider;
import java.util.Set;

public class PayloadAndCogWarningProviderImpl
implements PayloadAndCogWarningProvider {
    private PayloadAndCogWarningCalculator payloadAndCogWarningCalculator;
    private final RobotTypeIdentificationProvider robotTypeIdentificationProvider;
    private final Set<PayloadAndCogWarningCalculator> payloadAndCogWarningCalculatorSet;

    @Inject
    public PayloadAndCogWarningProviderImpl(RobotTypeIdentificationProvider robotIdentificationProvider, Set<PayloadAndCogWarningCalculator> payloadAndCogWarningCalculatorSet) {
        this.robotTypeIdentificationProvider = robotIdentificationProvider;
        this.payloadAndCogWarningCalculatorSet = payloadAndCogWarningCalculatorSet;
    }

    public PayloadAndCogWarningCalculator getPayloadAndCogWarning() {
        if (this.payloadAndCogWarningCalculator == null) {
            this.payloadAndCogWarningCalculator = this.determinePayloadAndCogWarning();
        }
        return this.payloadAndCogWarningCalculator;
    }

    private boolean supportsRobotType(RobotTypeIdentification id, Object o) {
        if (o instanceof RobotTypeSubTypeSupport) {
            return ((RobotTypeSubTypeSupport)o).supportsRobotType(id.robotType().getId(), id.robotSubType());
        }
        if (o instanceof RobotTypeSupport) {
            return ((RobotTypeSupport)o).supportsRobotType(id.robotType().getId());
        }
        return false;
    }

    private PayloadAndCogWarningCalculator determinePayloadAndCogWarning() {
        RobotTypeIdentification id = this.robotTypeIdentificationProvider.getRobotTypeIdentification();
        for (PayloadAndCogWarningCalculator calculator : this.payloadAndCogWarningCalculatorSet) {
            if (!this.supportsRobotType(id, calculator)) continue;
            return calculator;
        }
        throw new IllegalStateException("Unsupported RobotType: " + id.robotType().getId());
    }
}

