/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.payload;

import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.vecmath.Point2d;

public class PayloadValidationFunctionFactory {
    public static ValidPayloadFunction create(PayloadAndCogWarningCalculatorHelper calculationHelper, Point2d[] slope) {
        return (mass, cogDistance) -> {
            if (!calculationHelper.isBelowWeightLimit(mass, slope[0].y)) {
                return false;
            }
            if (!calculationHelper.isBelowLengthLimit(cogDistance, slope[slope.length - 1].x)) {
                return false;
            }
            for (int i = 1; i < slope.length - 1; ++i) {
                if (!calculationHelper.isBelowSlopedLimit(mass, cogDistance, slope[i], slope[i + 1])) continue;
                return true;
            }
            return false;
        };
    }

    public static interface ValidPayloadFunction {
        public boolean isBelowWeightLimit(Weight var1, Length var2);
    }
}

