/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentification;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class GetRobotIdentificationAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser getRobotModel = new ScriptActionDefinitionParser("get robot model");
    private static final ScriptActionDefinitionParser getRobotSerialNumber = new ScriptActionDefinitionParser("get serial number");
    private RobotTypeIdentification robotTypeIdentification;

    @Inject
    public GetRobotIdentificationAction(RobotTypeIdentificationProvider robotTypeIdentificationProvider) {
        this.robotTypeIdentification = robotTypeIdentificationProvider.getRobotTypeIdentification();
    }

    public boolean canHandleMessage(String input) {
        return getRobotModel.isMatch(input) || getRobotSerialNumber.isMatch(input);
    }

    public String execute(String input) {
        if (getRobotModel.isMatch(input)) {
            return this.robotTypeIdentification.robotType().name();
        }
        return this.robotTypeIdentification.getSerialNumber().getSerialNumber();
    }
}

