/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.internal.TextResource;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentification;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentifierImpl;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialNumberImpl;
import com.ur.polyscope.robot.configuration.internal.robotidentification.ValidRobotIdentificationCheck;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumber;
import com.ur.view.constants.dev.robotsize.RobotType;
import javax.inject.Inject;

public class RobotIdentificationImpl
implements RobotTypeIdentification {
    public static final RobotIdentificationImpl UNDEFINED = new RobotIdentificationImpl(SerialNumberImpl.UNKNOWN_SERIAL, RobotType.UNDEFINED);
    private static HMCInterface hmcInterface;
    private static TextResource textResource;
    private static RobotConfigurationProvider robotConfigurationProvider;
    private final SerialNumber serialNumber;
    private final RobotType robotType;
    private final RobotTypeIdentifier robotTypeIdentifier;

    private RobotIdentificationImpl(SerialNumber serialNumber, RobotType robotType) {
        this.serialNumber = serialNumber;
        this.robotType = robotType;
        this.robotTypeIdentifier = new RobotTypeIdentifierImpl(serialNumber, robotType);
    }

    public RobotIdentificationImpl(SerialNumber serialNumber, RobotType robotType, ValidRobotIdentificationCheck identificationCheck) {
        identificationCheck.isValid(serialNumber, robotType);
        this.serialNumber = serialNumber;
        this.robotType = robotType;
        this.robotTypeIdentifier = new RobotTypeIdentifierImpl(serialNumber, robotType);
    }

    @Inject
    public static void setHMCInterface(HMCInterface hmcInterface) {
        RobotIdentificationImpl.hmcInterface = hmcInterface;
    }

    @Inject
    public static void setTextResource(TextResource textResource) {
        RobotIdentificationImpl.textResource = textResource;
    }

    @Inject
    static void setRobotConfigurationProvider(RobotConfigurationProvider robotConfigurationProvider) {
        RobotIdentificationImpl.robotConfigurationProvider = robotConfigurationProvider;
    }

    public SerialNumber getTeachPendantSerialNumber() {
        HMCResponse response = hmcInterface.sendHMCMessageAndWait("get_tp_serial_number()");
        if (response == null) {
            return new SerialNumberImpl("");
        }
        if (response.getResponseData().length == 0) {
            return new SerialNumberImpl(textResource.na());
        }
        return new SerialNumberImpl(new String(response.getResponseData()));
    }

    public SerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public RobotType robotType() {
        return this.robotType;
    }

    @Override
    public int robotSubType() {
        return this.serialNumber.getSubType();
    }

    public RobotTypeIdentifier getRobotTypeId() {
        return this.robotTypeIdentifier;
    }

    public boolean isRobotTypeSpecified() {
        return this.robotType != RobotType.UNDEFINED;
    }

    public boolean isSpecified() {
        return this.robotType != RobotType.UNDEFINED && this.serialNumber != SerialNumberImpl.UNKNOWN_SERIAL;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RobotIdentificationImpl other = (RobotIdentificationImpl)obj;
        return EqualsUtil.equals((Object)other.getSerialNumber(), (Object)this.serialNumber);
    }

    public int hashCode() {
        int result = this.serialNumber != null ? this.serialNumber.hashCode() : 0;
        result = 31 * result + (this.robotType != null ? this.robotType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.serialNumber + " : " + robotConfigurationProvider.getRobotID().getTypeAsString();
    }

    public static RobotIdentificationImpl withUnknownSerial(RobotType robotType) {
        return new RobotIdentificationImpl(SerialNumberImpl.UNKNOWN_SERIAL, robotType);
    }
}

