/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.disk.Directories;
import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotIdentificationImpl;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentification;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentifierImpl;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialInfoExtractor;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialNumberImpl;
import com.ur.polyscope.robot.configuration.internal.robotidentification.URFileUtils;
import com.ur.polyscope.robot.configuration.internal.robotidentification.ValidRobotIdentificationCheck;
import com.ur.polyscope.robot.configuration.robotidentification.ControlBoxType;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumberListener;
import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;
import com.ur.util.persist.Options;
import com.ur.util.persist.OptionsSection;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;

@Singleton
public class RobotIdentificationProviderImpl
implements RobotTypeIdentificationProvider {
    private static final HashMap<RobotType, String> ROBOT_TYPE_CONF_PREFIX_MAP = new HashMap<RobotType, String>(){
        {
            this.put(RobotType.UR8_LONG, "UR8LONG");
        }
    };
    private static final List<String> VIEW_NAME_PERMISSIONS = Arrays.asList("systemBackup", "licenses", "urcaps", "remoteControl", "constrainedFreedrive", "network", "update");
    public static final String SERIAL_FILE_NAME = "ur-serial";
    public static final String CONFIGURATION_FILENAME = "urcontrol.conf";
    private static final Logger LOG = LogFactory.createLogger(RobotIdentificationProvider.class);
    private final File serialFile;
    private final File configrationFile;
    private final SerialInfoExtractor serialInfoExtractor;
    private final ValidRobotIdentificationCheck identificationCheck;
    private File urcontrolFile;
    private RobotTypeIdentification robotIdentification = RobotIdentificationImpl.UNDEFINED;
    private SerialNumberImpl serialNumber;
    private Set<SerialNumberListener> listeners = Collections.emptySet();

    @Inject
    public RobotIdentificationProviderImpl(SerialInfoExtractor serialInfoExtractor, ValidRobotIdentificationCheck identificationCheck) {
        this(Directories.home(), Directories.urcontrol(), serialInfoExtractor, identificationCheck);
    }

    public RobotIdentification fromStringHydrateProgram(String serialAsNumber) {
        try {
            SerialNumberImpl serialNumberFromProgram = new SerialNumberImpl(serialAsNumber);
            return new RobotIdentificationImpl(serialNumberFromProgram, this.serialInfoExtractor.robotType(serialNumberFromProgram), this.identificationCheck);
        }
        catch (Exception e) {
            LOG.warn("Unable to extract robot type from serial " + serialAsNumber, (Throwable)e);
            return RobotIdentificationImpl.UNDEFINED;
        }
    }

    @Inject
    public void registerSerialNumberListeners(Set<SerialNumberListener> listeners) {
        this.listeners = listeners;
    }

    RobotIdentificationProviderImpl(File urSerialPath, File configurationPath, SerialInfoExtractor serialInfoExtractor, ValidRobotIdentificationCheck identificationCheck) {
        Defense.notNull((Object)urSerialPath);
        Defense.notNull((Object)configurationPath);
        this.serialFile = new File(urSerialPath, SERIAL_FILE_NAME);
        this.configrationFile = new File(configurationPath, CONFIGURATION_FILENAME);
        this.serialInfoExtractor = serialInfoExtractor;
        this.identificationCheck = identificationCheck;
    }

    public void setRobotIdentification(String serialNumber, RobotTypeIdentifier robotType, ControlBoxType controlBoxType) {
        this.robotIdentification = this.createSerialFile(serialNumber, RobotType.byId((int)robotType.getRobotTypeId()), controlBoxType);
        this.listeners.stream().iterator().forEachRemaining(listener -> listener.serialNumberChanged((RobotIdentification)this.robotIdentification));
    }

    public RobotIdentification get() {
        return this.loadOrGetRobotTypeIdentification();
    }

    @Override
    public RobotTypeIdentification getRobotTypeIdentification() {
        return this.loadOrGetRobotTypeIdentification();
    }

    public RobotTypeIdentifier getDefaultRobotTypeId() {
        return new RobotTypeIdentifierImpl(this.serialNumber, RobotType.UR5);
    }

    public boolean isSmallRobot() {
        return this.get().getRobotTypeId().getRobotTypeId() == RobotType.UR3.getId();
    }

    private RobotTypeIdentification loadOrGetRobotTypeIdentification() {
        if (this.robotIdentification.isSpecified()) {
            return this.robotIdentification;
        }
        this.robotIdentification = this.tryLoadSerialNumber();
        return this.robotIdentification;
    }

    private RobotTypeIdentification tryLoadSerialNumber() {
        try {
            return this.loadSerialNumber();
        }
        catch (ValidRobotIdentificationCheck.SerialNumberIsIncorrectForRobotType e) {
            LOG.warn("Unable to load serial number", (Throwable)e);
            RobotType robotType = this.robotTypeFromControllerConfigurationFile();
            return RobotIdentificationImpl.withUnknownSerial(robotType);
        }
    }

    private synchronized RobotTypeIdentification loadSerialNumber() {
        String serialAsString;
        if (!this.doesSerialFileExist()) {
            this.writeSecurityPermissionsFile();
            return this.undefinedRobotIdentification();
        }
        try {
            serialAsString = URFileUtils.readFirstLine(this.serialFile);
        }
        catch (IOException e) {
            Log.error((String)"Could not read ur-serial file", (Throwable)e);
            return this.undefinedRobotIdentification();
        }
        if (StringUtils.isNullOrEmpty((String)serialAsString)) {
            return this.undefinedRobotIdentification();
        }
        this.serialNumber = new SerialNumberImpl(serialAsString);
        return new RobotIdentificationImpl(this.serialNumber, this.robotTypeFromControllerConfigurationFile(), this.identificationCheck);
    }

    private void writeSecurityPermissionsFile() {
        WriteableModuleSettings settings = new WriteableModuleSettings(".permissions.properties");
        NiceProperties properties = settings.properties();
        long timestamp = properties.getLong("timestamp", System.currentTimeMillis());
        if (System.currentTimeMillis() - timestamp < TimeUnit.MINUTES.toMillis(10L)) {
            properties.setProperty("timestamp", String.valueOf(System.currentTimeMillis()));
            VIEW_NAME_PERMISSIONS.forEach(viewName -> properties.setProperty(viewName, Boolean.toString(true)));
            try {
                settings.write();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to write permissions file", e);
            }
        }
    }

    private boolean doesSerialFileExist() {
        return this.serialFile.exists() && this.serialFile.isFile();
    }

    private RobotTypeIdentification createSerialFile(String serialNumberAsString, RobotType robotType, ControlBoxType controlBoxType) {
        try {
            this.writeSerialNumberToFile(serialNumberAsString);
            this.useRobotConfigFile(robotType, controlBoxType);
        }
        catch (IOException e) {
            Log.error((String)"Failed to write file", (Throwable)e);
            throw new IllegalStateException("Unable to specify Serial Number or Robot Type", e);
        }
        return new RobotIdentificationImpl(new SerialNumberImpl(serialNumberAsString), robotType, this.identificationCheck);
    }

    private void writeSerialNumberToFile(String serialNumberAsString) throws IOException {
        this.serialFile.setWritable(true);
        URFileUtils.writeFile(this.serialFile.getAbsolutePath(), serialNumberAsString);
        this.serialFile.setReadOnly();
    }

    private RobotTypeIdentification undefinedRobotIdentification() {
        return new RobotIdentificationImpl(SerialNumberImpl.UNKNOWN_SERIAL, this.robotTypeFromControllerConfigurationFile(), this.identificationCheck);
    }

    private void useRobotConfigFile(RobotType type, ControlBoxType controlBoxType) {
        String controllerConfigurationFile = RobotIdentificationProviderImpl.getControllerConfigurationFile();
        this.urcontrolFile = controlBoxType == ControlBoxType.OEM_DC ? new File(this.getConfigurationNameFromRobotType(type) + "_DC") : new File(this.getConfigurationNameFromRobotType(type));
        if (!this.urcontrolFile.exists()) {
            LOG.warn(type + " configuration file not found", new Object[0]);
            return;
        }
        if (!URFileUtils.tryCreateSymLink(this.urcontrolFile.getName(), controllerConfigurationFile)) {
            LOG.warn("Unable to create symlink between " + this.urcontrolFile.getName() + " and " + controllerConfigurationFile, new Object[0]);
        }
    }

    private String getConfigurationNameFromRobotType(RobotType robotType) {
        return RobotIdentificationProviderImpl.getControllerConfigurationFile() + "." + ROBOT_TYPE_CONF_PREFIX_MAP.getOrDefault(robotType, robotType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RobotType robotTypeFromControllerConfigurationFile() {
        RobotType rt = RobotType.UNDEFINED;
        FileReader fr = null;
        try {
            fr = new FileReader(this.configrationFile);
            Options options = new Options();
            options.load((Reader)fr);
            OptionsSection os = options.getSection("Hardware");
            rt = RobotType.byId((int)os.getInt("robot_type", 0));
        }
        catch (FileNotFoundException ex) {
            try {
                Log.warning((String)"Did not find the urcontrol.conf file", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)fr);
        }
        IOUtils.closeQuietly((Reader)fr);
        return rt;
    }

    protected File getUrcontrolFile() {
        return this.urcontrolFile;
    }

    private static String getControllerConfigurationFile() {
        return Directories.urcontrol().getPath() + File.separator + CONFIGURATION_FILENAME;
    }
}

