/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.polyscope.robot.configuration.internal.RobotTypeContribution;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialNumberCheck;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumber;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.util.Set;
import javax.inject.Inject;

public class RobotTypeIdentifierImpl
implements RobotTypeIdentifier {
    private final RobotType robotType;
    private final String robotTypeName;
    private static final SerialNumberCheck serialNumberCheck = new SerialNumberCheck();
    private static Set<RobotTypeContribution> robotTypeContributions;

    public RobotTypeIdentifierImpl(SerialNumber serialNumber, RobotType robotType) {
        this.robotType = robotType;
        this.robotTypeName = robotType == RobotType.UR5 ? (serialNumber.getSubType() == 7 ? "UR7" : "UR5") : (robotType == RobotType.UR10 ? (serialNumber.getSubType() == 1 ? "UR12" : "UR10") : robotType.name());
    }

    public RobotTypeIdentifierImpl(RobotType robotType) {
        this.robotType = robotType;
        this.robotTypeName = robotType.name();
    }

    @Inject
    public static void setRobotTypeContributions(Set<RobotTypeContribution> robotTypeContributions) {
        RobotTypeIdentifierImpl.robotTypeContributions = robotTypeContributions;
        SerialNumberCheck.setRobotTypeContributions(robotTypeContributions);
    }

    public int getRobotTypeId() {
        return this.robotType.getId();
    }

    public String getRobotTypeName() {
        return this.robotTypeName;
    }

    public boolean isAllowedOnG3() {
        return this.robotTypeAllowedOnG3(this.robotType);
    }

    public boolean isValidSerial(String serial) {
        return serialNumberCheck.isValid(serial, this.robotType);
    }

    public String expectedSerialPattern() {
        return serialNumberCheck.expectedPattern(this.robotType);
    }

    private boolean robotTypeAllowedOnG3(RobotType value) {
        if (value == RobotType.UR16) {
            return false;
        }
        for (RobotTypeContribution contributedType : robotTypeContributions) {
            if (!contributedType.supportsRobotType(value.getId())) continue;
            return contributedType.isAllowedOnG3();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RobotTypeIdentifierImpl that = (RobotTypeIdentifierImpl)o;
        return this.robotType == that.robotType;
    }

    public int hashCode() {
        return this.robotType.name().hashCode();
    }
}

