/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.polyscope.robot.configuration.internal.RobotTypeContribution;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialNumberImpl;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumber;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.util.Set;
import javax.inject.Inject;

public class SerialInfoExtractor {
    private final Set<RobotTypeContribution> robotTypeContributions;

    @Inject
    public SerialInfoExtractor(Set<RobotTypeContribution> robotTypeContributions) {
        this.robotTypeContributions = robotTypeContributions;
    }

    public RobotType robotType(SerialNumber serial) {
        switch (serial.getRobotType()) {
            case 33: 
            case 43: 
            case 53: {
                return RobotType.UR3;
            }
            case 35: 
            case 55: 
            case 57: {
                return RobotType.UR5;
            }
            case 66: {
                return RobotType.UR8_LONG;
            }
            case 30: 
            case 50: 
            case 51: 
            case 52: {
                return RobotType.UR10;
            }
            case 67: {
                return RobotType.UR15;
            }
            case 56: {
                return RobotType.UR16;
            }
            case 65: {
                return RobotType.UR18;
            }
            case 68: {
                return RobotType.UR20;
            }
            case 69: {
                return RobotType.UR30;
            }
        }
        return this.getRobotTypeFromAdditionalRobots(serial);
    }

    private RobotType getRobotTypeFromAdditionalRobots(SerialNumber serial) {
        for (RobotTypeContribution contributedType : this.robotTypeContributions) {
            int robotType = contributedType.getRobotTypeIdFromController(serial);
            if (robotType == -1) continue;
            return RobotType.byId((int)robotType);
        }
        throw new SerialNumberImpl.BadSerialNumber("Serial number doesn't match for any known robot types: " + serial);
    }
}

