/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.lang.StringUtils;
import com.ur.polyscope.robot.configuration.internal.RobotTypeContribution;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.util.Set;
import java.util.regex.Pattern;

public class SerialNumberCheck {
    private static Set<RobotTypeContribution> robotTypeContributions;

    public static void setRobotTypeContributions(Set<RobotTypeContribution> robotTypeContributions) {
        SerialNumberCheck.robotTypeContributions = robotTypeContributions;
    }

    public boolean isValid(String uncheckedString, RobotType robotType) {
        if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
            return false;
        }
        String serialNumberIdentifier = this.getSerialNumberIdentifier(robotType);
        if ("".equals(serialNumberIdentifier)) {
            return false;
        }
        String generationIdentifier = this.getGenerationIdentifier(robotType);
        Pattern serialPattern = Pattern.compile("^[23][0-9]{3}" + generationIdentifier + serialNumberIdentifier + "[0-9]{5}$");
        return serialPattern.matcher(uncheckedString).matches();
    }

    private String getGenerationIdentifier(RobotType robotType) {
        switch (robotType) {
            case UR8_LONG: 
            case UR18: 
            case UR15: 
            case UR20: 
            case UR30: {
                return "6";
            }
        }
        return "5";
    }

    public String expectedPattern(RobotType robotType) {
        String robotTypeId = this.getSerialNumberIdentifier(robotType);
        String generationIdentifier = this.getGenerationIdentifier(robotType);
        if (robotType == RobotType.UNDEFINED) {
            return "";
        }
        if (robotType == RobotType.UR10) {
            return "20YY" + generationIdentifier + "ZXXXXX";
        }
        return "20YY" + generationIdentifier + robotTypeId + "XXXXX";
    }

    private String getSerialNumberIdentifier(RobotType robotType) {
        switch (robotType) {
            case UR3: {
                return "3";
            }
            case UR5: {
                return "[57]";
            }
            case UR10: {
                return "[012]";
            }
            case UR15: {
                return "7";
            }
            case UR8_LONG: 
            case UR16: {
                return "6";
            }
            case UR18: {
                return "5";
            }
        }
        return this.getSerialNumberIdentifierFromContributed(robotType);
    }

    private String getSerialNumberIdentifierFromContributed(RobotType robotType) {
        if (robotTypeContributions == null || robotTypeContributions.isEmpty()) {
            return "";
        }
        String serialNumberIdentifier = "";
        for (RobotTypeContribution robotTypeContribution : robotTypeContributions) {
            if (!robotTypeContribution.supportsRobotType(robotType.getId())) continue;
            serialNumberIdentifier = "" + robotTypeContribution.getSerialNumberIdentifier();
        }
        return serialNumberIdentifier;
    }
}

