/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumber;

public class SerialNumberImpl
implements SerialNumber {
    public static final SerialNumberImpl UNKNOWN_SERIAL = new SerialNumberImpl("????");
    private static final int VARIANT_ENCODE = 1;
    private static final int PRODUCER_ENCODE = 0;
    private static final int GENERATION_ENCODE = 4;
    private static final int SUB_TYPE_ENCODE = 5;
    private final String serial;

    public SerialNumberImpl(String serial) {
        this.serial = serial;
    }

    public String getSerialNumber() {
        return this.serial;
    }

    public int getRobotType() {
        return this.getGeneration() * 10 + this.getSubType();
    }

    public int getGeneration() {
        return this.tryGetInt(4, -1);
    }

    public int getSubType() {
        return this.tryGetInt(5, 7);
    }

    public int getProducer() {
        return this.tryGetInt(0, -1);
    }

    public int getVariant() {
        return this.tryGetInt(1, -1);
    }

    private int tryGetInt(int encoding, int defaultValue) {
        try {
            return PrimitiveUtils.parseInteger((String)("" + this.serial.charAt(encoding)), (int)defaultValue);
        }
        catch (StringIndexOutOfBoundsException e) {
            return defaultValue;
        }
    }

    public String toString() {
        return "s/n: " + this.getSerialNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SerialNumber)) {
            return false;
        }
        SerialNumber that = (SerialNumber)o;
        return this.serial.equals(that.getSerialNumber());
    }

    public int hashCode() {
        return this.serial.hashCode();
    }

    public static class BadSerialNumber
    extends RuntimeException {
        public BadSerialNumber(String s) {
            super(s);
        }
    }
}

