/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

final class URFileUtils {
    private URFileUtils() {
    }

    static boolean tryCreateSymLink(String fileToLinkTo, String symLinkSource) {
        try {
            URFileUtils.createSymLink(fileToLinkTo, symLinkSource);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void createSymLink(String symLinkTarget, String symLinkSource) throws IOException, InterruptedException {
        if (new File(symLinkSource).exists()) {
            return;
        }
        Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", symLinkTarget, symLinkSource});
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Log.error((String)("Failed to create symlink! (target = " + symLinkTarget + ", symLinkFile = " + symLinkSource + ")"));
            throw e;
        }
        finally {
            process.destroy();
        }
    }

    static String readFirstLine(File file) throws IOException {
        String line = null;
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            line = input.readLine();
        }
        return line;
    }

    static void writeFile(String path, String contents) throws IOException {
        File newFile = new File(path);
        URFileUtils.writeFile(newFile, contents);
    }

    private static void writeFile(File file, String contents) throws IOException {
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
            output.write(contents);
            output.flush();
        }
    }
}

