/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.robotidentification;

import com.ur.lang.StringUtils;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialInfoExtractor;
import com.ur.polyscope.robot.configuration.internal.robotidentification.SerialNumberImpl;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumber;
import com.ur.view.constants.dev.robotsize.RobotType;
import javax.inject.Inject;

public class ValidRobotIdentificationCheck {
    private final SerialInfoExtractor serialInfoExtractor;

    @Inject
    public ValidRobotIdentificationCheck(SerialInfoExtractor serialInfoExtractor) {
        this.serialInfoExtractor = serialInfoExtractor;
    }

    public void isValid(SerialNumber serialNumber, RobotType robotType) {
        if (this.serialNumberIsDefined(serialNumber)) {
            this.serialNumberIsValidForRobotType(serialNumber, robotType);
        }
    }

    private boolean serialNumberIsDefined(SerialNumber serialNumber) {
        return !StringUtils.isNullOrOnlyWhitespace((String)serialNumber.getSerialNumber()) && !serialNumber.equals(SerialNumberImpl.UNKNOWN_SERIAL);
    }

    private void serialNumberIsValidForRobotType(SerialNumber serialNumber, RobotType robotType) {
        RobotType robotTypeDefinedInSerial = this.serialInfoExtractor.robotType(serialNumber);
        if (robotType != robotTypeDefinedInSerial) {
            throw new SerialNumberIsIncorrectForRobotType(robotTypeDefinedInSerial, robotType);
        }
    }

    public static class SerialNumberIsIncorrectForRobotType
    extends RuntimeException {
        public SerialNumberIsIncorrectForRobotType(RobotType robotTypeDefinedInSerial, RobotType robotType) {
            super("serial number is for: " + robotTypeDefinedInSerial + ", but should be for " + robotType);
        }
    }
}

