/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.teachpendent;

import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapableProvider;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class TPCapableProviderImpl
implements TPCapableProvider {
    private final Set<TPCapable> tpCapables;
    private final RobotTypeIdentificationProvider robotTypeIdentificationProvider;

    @Inject
    public TPCapableProviderImpl(Set<TPCapable> tpCapables, RobotTypeIdentificationProvider robotTypeIdentificationProvider) {
        this.tpCapables = tpCapables;
        this.robotTypeIdentificationProvider = robotTypeIdentificationProvider;
    }

    public Optional<TPCapable> getTPCapable() {
        RobotTypeIdentifier robotIdentification = this.robotTypeIdentificationProvider.getRobotTypeIdentification().getRobotTypeId();
        for (TPCapable tpCapable : this.tpCapables) {
            if (!tpCapable.supportsRobotType(robotIdentification.getRobotTypeId())) continue;
            return Optional.ofNullable(tpCapable);
        }
        return Optional.empty();
    }
}

