/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur10;

import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadValidationFunctionFactory;
import com.ur.polyscope.robot.configuration.internal.ur10.RobotTypeSupportUR10;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR10Impl
implements PayloadAndCogWarningCalculator,
RobotTypeSupportUR10 {
    public static final Point2d[] SLOPE = new Point2d[]{new Point2d(0.0, 10.0), new Point2d(0.15, 10.0), new Point2d(0.8, 5.0)};
    private final PayloadValidationFunctionFactory.ValidPayloadFunction validPayloadFunction;

    @Inject
    public PayloadAndCogWarningCalculatorUR10Impl(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.validPayloadFunction = PayloadValidationFunctionFactory.create(payloadAndCogWarningCalculatorHelper, SLOPE);
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.validPayloadFunction.isBelowWeightLimit(mass, cogDistance);
    }

    @Override
    public boolean supportsRobotType(int robotTypeId, int robotSubTypeId) {
        return this.supportsRobotType(robotTypeId) && robotSubTypeId == 0;
    }
}

